/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.blocks.IAdvancedRotationTexture;
import techreborn.Core;
import techreborn.client.EGui;
import techreborn.client.TechRebornCreativeTab;
import techreborn.tiles.TileDigitalChest;
import techreborn.tiles.TileTechStorageBase;

public class BlockDigitalChest
extends BlockMachineBase
implements IAdvancedRotationTexture {
    private final String prefix = "techreborn:blocks/machine/greg_machines/";

    public BlockDigitalChest() {
        this.setUnlocalizedName("techreborn.digitalChest");
        this.setCreativeTab(TechRebornCreativeTab.instance);
    }

    protected void dropInventory(World world, BlockPos pos) {
        TileEntity tileEntity = world.getTileEntity(pos);
        if (tileEntity == null) {
            return;
        }
        if (!(tileEntity instanceof TileTechStorageBase)) {
            return;
        }
        TileTechStorageBase inventory = (TileTechStorageBase)tileEntity;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        List<ItemStack> droppables = inventory.getContentDrops();
        for (int i = 0; i < droppables.size(); ++i) {
            ItemStack itemStack = droppables.get(i);
            if (itemStack == null || itemStack != null && itemStack.stackSize > 0 && itemStack.getItem() instanceof ItemBlock && (((ItemBlock)itemStack.getItem()).block instanceof BlockFluidBase || ((ItemBlock)itemStack.getItem()).block instanceof BlockStaticLiquid || ((ItemBlock)itemStack.getItem()).block instanceof BlockDynamicLiquid)) continue;
            items.add(itemStack.copy());
        }
        for (ItemStack itemStack : items) {
            Random rand = new Random();
            float dX = rand.nextFloat() * 0.8f + 0.1f;
            float dY = rand.nextFloat() * 0.8f + 0.1f;
            float dZ = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)pos.getX() + dX), (double)((float)pos.getY() + dY), (double)((float)pos.getZ() + dZ), itemStack.copy());
            if (itemStack.hasTagCompound()) {
                entityItem.getEntityItem().setTagCompound(itemStack.getTagCompound().copy());
            }
            float factor = 0.05f;
            entityItem.motionX = rand.nextGaussian() * (double)0.05f;
            entityItem.motionY = rand.nextGaussian() * (double)0.05f + (double)0.2f;
            entityItem.motionZ = rand.nextGaussian() * (double)0.05f;
            world.spawnEntity((Entity)entityItem);
            itemStack.stackSize = 0;
        }
    }

    public TileEntity createNewTileEntity(World p_149915_1_, int p_149915_2_) {
        return new TileDigitalChest();
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!player.isSneaking()) {
            player.openGui((Object)Core.INSTANCE, EGui.DIGITAL_CHEST.ordinal(), world, x, y, z);
        }
        return true;
    }

    public String getFront(boolean isActive) {
        return this.prefix + "quantum_chest";
    }

    public String getSide(boolean isActive) {
        return this.prefix + "qchest_side";
    }

    public String getTop(boolean isActive) {
        return this.prefix + "quantum_top";
    }

    public String getBottom(boolean isActive) {
        return this.prefix + "machine_bottom";
    }
}

