/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks;

import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.blocks.IAdvancedRotationTexture;
import techreborn.Core;
import techreborn.client.EGui;
import techreborn.client.TechRebornCreativeTab;
import techreborn.tiles.fusionReactor.TileEntityFusionController;
import techreborn.utils.damageSources.FusionDamageSource;

public class BlockFusionControlComputer
extends BlockMachineBase
implements IAdvancedRotationTexture {
    private final String prefix = "techreborn:blocks/machine/greg_machines/";

    public BlockFusionControlComputer(Material material) {
        this.setUnlocalizedName("techreborn.fusioncontrolcomputer");
        this.setCreativeTab(TechRebornCreativeTab.instance);
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntityFusionController tileEntityFusionController = (TileEntityFusionController)world.getTileEntity(new BlockPos(x, y, z));
        tileEntityFusionController.checkCoils();
        if (!player.isSneaking()) {
            player.openGui((Object)Core.INSTANCE, EGui.FUSION_CONTROLLER.ordinal(), world, x, y, z);
        }
        return true;
    }

    public void onEntityWalk(World worldIn, BlockPos pos, Entity entityIn) {
        super.onEntityWalk(worldIn, pos, entityIn);
        if (worldIn.getTileEntity(pos) instanceof TileEntityFusionController && ((TileEntityFusionController)worldIn.getTileEntity((BlockPos)pos)).crafingTickTime != 0 && ((TileEntityFusionController)worldIn.getTileEntity(pos)).checkCoils()) {
            entityIn.attackEntityFrom((DamageSource)new FusionDamageSource(), 200.0f);
        }
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        return new TileEntityFusionController();
    }

    public String getFront(boolean isActive) {
        return this.prefix + "fusion_control_computer_front";
    }

    public String getSide(boolean isActive) {
        return this.prefix + "machine_side";
    }

    public String getTop(boolean isActive) {
        return this.prefix + "machine_side";
    }

    public String getBottom(boolean isActive) {
        return this.prefix + "machine_side";
    }
}

