/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks;

import com.google.common.base.CaseFormat;
import java.security.InvalidParameterException;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.common.multiblock.BlockMultiblockBase;
import techreborn.client.TechRebornCreativeTab;
import techreborn.init.ModBlocks;
import techreborn.tiles.TileMachineCasing;

public class BlockMachineCasing
extends BlockMultiblockBase {
    public static final String[] types = new String[]{"standard", "reinforced", "advanced"};
    public static final PropertyInteger METADATA = PropertyInteger.create((String)"type", (int)0, (int)types.length);

    public BlockMachineCasing(Material material) {
        super(material);
        this.setCreativeTab(TechRebornCreativeTab.instance);
        this.setUnlocalizedName("techreborn.machineCasing");
        this.setHardness(2.0f);
        this.setDefaultState(this.getDefaultState().withProperty((IProperty)METADATA, (Comparable)Integer.valueOf(0)));
    }

    public static ItemStack getStackByName(String name, int count) {
        name = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name);
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equalsIgnoreCase(name)) continue;
            return new ItemStack(ModBlocks.MACHINE_CASINGS, count, i);
        }
        throw new InvalidParameterException("The machine casing " + name + " could not be found.");
    }

    public static ItemStack getStackByName(String name) {
        return BlockMachineCasing.getStackByName(name, 1);
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)METADATA, (Comparable)Integer.valueOf(meta));
    }

    public int getMetaFromState(IBlockState state) {
        return (Integer)state.getValue((IProperty)METADATA);
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{METADATA});
    }

    public int getHeatFromState(IBlockState state) {
        switch (this.getMetaFromState(state)) {
            case 0: {
                return 40;
            }
            case 1: {
                return 68;
            }
            case 2: {
                return 95;
            }
        }
        return 0;
    }

    public Item getItemDropped(IBlockState state, Random rand, int fortune) {
        return Item.getItemFromBlock((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item item, CreativeTabs creativeTabs, List<ItemStack> list) {
        for (int meta = 0; meta < types.length; ++meta) {
            list.add(new ItemStack(item, 1, meta));
        }
    }

    public int damageDropped(IBlockState state) {
        return this.getMetaFromState(state);
    }

    public TileEntity createNewTileEntity(World p_149915_1_, int p_149915_2_) {
        return new TileMachineCasing();
    }
}

