/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks;

import com.google.common.base.CaseFormat;
import java.security.InvalidParameterException;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.common.BaseBlock;
import techreborn.client.TechRebornCreativeTab;
import techreborn.init.ModBlocks;

public class BlockMachineFrame
extends BaseBlock {
    public static final String[] types = new String[]{"machine", "advancedMachine", "highlyAdvancedMachine"};
    public static final PropertyInteger METADATA = PropertyInteger.create((String)"type", (int)0, (int)(types.length - 1));

    public BlockMachineFrame(Material material) {
        super(material);
        this.setUnlocalizedName("techreborn.machineFrame");
        this.setCreativeTab(TechRebornCreativeTab.instance);
        this.setHardness(1.0f);
        this.setDefaultState(this.getDefaultState().withProperty((IProperty)METADATA, (Comparable)Integer.valueOf(0)));
    }

    public static ItemStack getFrameByName(String name, int count) {
        name = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name);
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equalsIgnoreCase(name)) continue;
            return new ItemStack(ModBlocks.MACHINE_FRAMES, count, i);
        }
        throw new InvalidParameterException("The part " + name + " could not be found.");
    }

    public static ItemStack getFrameByName(String name) {
        return BlockMachineFrame.getFrameByName(name, 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item item, CreativeTabs creativeTabs, List<ItemStack> list) {
        for (int meta = 0; meta < types.length; ++meta) {
            list.add(new ItemStack(item, 1, meta));
        }
    }

    public int damageDropped(IBlockState state) {
        return this.getMetaFromState(state);
    }

    public int getMetaFromState(IBlockState state) {
        return (Integer)state.getValue((IProperty)METADATA);
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{METADATA});
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)METADATA, (Comparable)Integer.valueOf(meta));
    }
}

