/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks;

import me.modmuss50.jsonDestroyer.api.ITexturedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import reborncore.RebornCore;
import reborncore.common.BaseBlock;
import techreborn.client.TechRebornCreativeTabMisc;
import techreborn.entitys.EntityNukePrimed;

public class BlockNuke
extends BaseBlock
implements ITexturedBlock {
    public static final PropertyBool OVERLAY = PropertyBool.create((String)"overlay");

    public BlockNuke() {
        super(Material.TNT);
        this.setUnlocalizedName("techreborn.nuke");
        this.setCreativeTab(TechRebornCreativeTabMisc.instance);
        RebornCore.jsonDestroyer.registerObject((Object)this);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)OVERLAY, (Comparable)Boolean.valueOf(false)));
    }

    public void explode(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase igniter) {
        if (!worldIn.isRemote) {
            EntityNukePrimed entitynukeprimed = new EntityNukePrimed(worldIn, (float)pos.getX() + 0.5f, pos.getY(), (float)pos.getZ() + 0.5f, igniter);
            worldIn.spawnEntity((Entity)entitynukeprimed);
        }
    }

    public void onBlockDestroyedByExplosion(World worldIn, BlockPos pos, Explosion explosionIn) {
        if (!worldIn.isRemote) {
            EntityNukePrimed entitynukeprimed = new EntityNukePrimed(worldIn, (float)pos.getX() + 0.5f, pos.getY(), (float)pos.getZ() + 0.5f, explosionIn.getExplosivePlacedBy());
            entitynukeprimed.fuse = worldIn.rand.nextInt(entitynukeprimed.fuse / 4) + entitynukeprimed.fuse / 8;
            worldIn.spawnEntity((Entity)entitynukeprimed);
        }
    }

    public void onEntityCollidedWithBlock(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        EntityArrow entityarrow;
        if (!worldIn.isRemote && entityIn instanceof EntityArrow && (entityarrow = (EntityArrow)entityIn).isBurning()) {
            this.explode(worldIn, pos, state, entityarrow.shootingEntity instanceof EntityLivingBase ? (EntityLivingBase)entityarrow.shootingEntity : null);
            worldIn.setBlockToAir(pos);
        }
    }

    public void onBlockAdded(World worldIn, BlockPos pos, IBlockState state) {
        super.onBlockAdded(worldIn, pos, state);
        if (worldIn.isBlockPowered(pos)) {
            this.explode(worldIn, pos, state, null);
            worldIn.setBlockToAir(pos);
        }
    }

    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        if (worldIn.isBlockPowered(pos)) {
            this.explode(worldIn, pos, state, null);
            worldIn.setBlockToAir(pos);
        }
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack stack, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public String getTextureNameFromState(IBlockState iBlockState, EnumFacing enumFacing) {
        if (((Boolean)iBlockState.getValue((IProperty)OVERLAY)).booleanValue()) {
            return "techreborn:blocks/nuke_front";
        }
        if (enumFacing == EnumFacing.UP || enumFacing == EnumFacing.DOWN) {
            return "techreborn:blocks/nuke_top";
        }
        return "techreborn:blocks/nuke_side";
    }

    public int amountOfStates() {
        return 2;
    }

    public int getMetaFromState(IBlockState state) {
        return (Boolean)state.getValue((IProperty)OVERLAY) != false ? 1 : 0;
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)OVERLAY, (Comparable)Boolean.valueOf((meta & 1) > 0));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{OVERLAY});
    }
}

