/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.common.blocks.PropertyString;
import reborncore.common.util.ArrayUtils;
import reborncore.common.util.OreDrop;
import reborncore.common.util.OreDropSet;
import reborncore.common.util.StringUtils;
import techreborn.blocks.BlockOre2;
import techreborn.client.TechRebornCreativeTabMisc;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModBlocks;
import techreborn.items.ItemDusts;
import techreborn.items.ItemGems;
import techreborn.world.config.IOreNameProvider;

public class BlockOre
extends Block
implements IOreNameProvider {
    public static final String[] ores = new String[]{"galena", "iridium", "ruby", "sapphire", "bauxite", "pyrite", "cinnabar", "sphalerite", "tungsten", "sheldonite", "peridot", "sodalite", "lead", "silver"};
    private static final List<String> oreNamesList = Lists.newArrayList((Object[])ArrayUtils.arrayToLowercase((String[])ores));
    public static final PropertyString VARIANTS = new PropertyString("type", oreNamesList);

    public BlockOre(Material material) {
        super(material);
        this.setUnlocalizedName("techreborn.ore");
        this.setCreativeTab(TechRebornCreativeTabMisc.instance);
        this.setHardness(2.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.setDefaultState(this.getStateFromMeta(0));
    }

    public static ItemStack getOreByName(String name, int count) {
        for (int i = 0; i < ores.length; ++i) {
            if (!ores[i].equalsIgnoreCase(name)) continue;
            return new ItemStack((Block)ModBlocks.ORE, count, i);
        }
        return BlockOre2.getOreByName(name, count);
    }

    public static ItemStack getOreByName(String name) {
        return BlockOre.getOreByName(name, 1);
    }

    public IBlockState getBlockStateFromName(String name) {
        int index = -1;
        for (int i = 0; i < ores.length; ++i) {
            if (!ores[i].equalsIgnoreCase(name)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return ModBlocks.ORE2.getBlockStateFromName(name);
        }
        return this.getStateFromMeta(index);
    }

    @Deprecated
    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        String variant = (String)((Object)state.getValue((IProperty)VARIANTS));
        int meta = this.getMetaFromState(state);
        Random random = new Random();
        if (variant.equalsIgnoreCase("Ruby")) {
            OreDrop ruby = new OreDrop(ItemGems.getGemByName("ruby"), Double.valueOf(ConfigTechReborn.FortuneSecondaryOreMultiplierPerLevel));
            OreDrop redGarnet = new OreDrop(ItemGems.getGemByName("red_garnet"), Double.valueOf(0.02));
            OreDropSet set = new OreDropSet(new OreDrop[]{ruby});
            return set.drop(fortune, random);
        }
        if (variant.equalsIgnoreCase("Sapphire")) {
            OreDrop sapphire = new OreDrop(ItemGems.getGemByName("sapphire"), Double.valueOf(ConfigTechReborn.FortuneSecondaryOreMultiplierPerLevel));
            OreDrop peridot = new OreDrop(ItemGems.getGemByName("peridot"), Double.valueOf(0.03));
            OreDropSet set = new OreDropSet(new OreDrop[]{sapphire, peridot});
            return set.drop(fortune, random);
        }
        if (variant.equalsIgnoreCase("Pyrite")) {
            OreDrop pyriteDust = new OreDrop(ItemDusts.getDustByName("pyrite"), Double.valueOf(ConfigTechReborn.FortuneSecondaryOreMultiplierPerLevel));
            OreDropSet set = new OreDropSet(new OreDrop[]{pyriteDust});
            return set.drop(fortune, random);
        }
        if (variant.equalsIgnoreCase("Sodalite")) {
            OreDrop sodalite = new OreDrop(ItemDusts.getDustByName("sodalite", 6), Double.valueOf(ConfigTechReborn.FortuneSecondaryOreMultiplierPerLevel));
            OreDrop aluminum = new OreDrop(ItemDusts.getDustByName("aluminum"), Double.valueOf(0.5));
            OreDropSet set = new OreDropSet(new OreDrop[]{sodalite, aluminum});
            return set.drop(fortune, random);
        }
        if (variant.equalsIgnoreCase("Cinnabar")) {
            OreDrop cinnabar = new OreDrop(ItemDusts.getDustByName("cinnabar"), Double.valueOf(ConfigTechReborn.FortuneSecondaryOreMultiplierPerLevel));
            OreDrop redstone = new OreDrop(new ItemStack(Items.REDSTONE), Double.valueOf(0.25));
            OreDropSet set = new OreDropSet(new OreDrop[]{cinnabar, redstone});
            return set.drop(fortune, random);
        }
        if (variant.equalsIgnoreCase("Sphalerite")) {
            OreDrop sphalerite = new OreDrop(ItemDusts.getDustByName("sphalerite"), Double.valueOf(ConfigTechReborn.FortuneSecondaryOreMultiplierPerLevel));
            OreDrop yellowGarnet = new OreDrop(ItemGems.getGemByName("yellowGarnet"), Double.valueOf(0.125));
            OreDropSet set = new OreDropSet(new OreDrop[]{sphalerite, yellowGarnet});
            return set.drop(fortune, random);
        }
        ArrayList<ItemStack> block = new ArrayList<ItemStack>();
        block.add(new ItemStack(Item.getItemFromBlock((Block)this), 1, meta));
        return block;
    }

    protected boolean canSilkHarvest() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item item, CreativeTabs creativeTabs, List<ItemStack> list) {
        for (int meta = 0; meta < ores.length; ++meta) {
            list.add(new ItemStack(item, 1, meta));
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.getMetaFromState(state));
    }

    public int damageDropped(IBlockState state) {
        return this.getMetaFromState(state);
    }

    public IBlockState getStateFromMeta(int meta) {
        if (meta > ores.length) {
            meta = 0;
        }
        return this.getBlockState().getBaseState().withProperty((IProperty)VARIANTS, (Comparable)((Object)oreNamesList.get(meta)));
    }

    public int getMetaFromState(IBlockState state) {
        return oreNamesList.indexOf(state.getValue((IProperty)VARIANTS));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANTS});
    }

    @Override
    public String getUserLoclisedName(IBlockState state) {
        return StringUtils.toFirstCapital((String)oreNamesList.get(this.getMetaFromState(state)));
    }
}

