/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks;

import com.google.common.collect.Lists;
import java.security.InvalidParameterException;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.common.blocks.PropertyString;
import reborncore.common.util.ArrayUtils;
import reborncore.common.util.StringUtils;
import techreborn.client.TechRebornCreativeTabMisc;
import techreborn.init.ModBlocks;
import techreborn.world.config.IOreNameProvider;

public class BlockOre2
extends Block
implements IOreNameProvider {
    public static final String[] ores = new String[]{"copper", "tin"};
    static List<String> oreNamesList = Lists.newArrayList((Object[])ArrayUtils.arrayToLowercase((String[])ores));
    public PropertyString VARIANTS = new PropertyString("type", oreNamesList);

    public BlockOre2(Material material) {
        super(material);
        this.setUnlocalizedName("techreborn.ore2");
        this.setCreativeTab(TechRebornCreativeTabMisc.instance);
        this.setHardness(2.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.setDefaultState(this.getStateFromMeta(0));
    }

    public static ItemStack getOreByName(String name, int count) {
        for (int i = 0; i < ores.length; ++i) {
            if (!ores[i].equalsIgnoreCase(name)) continue;
            return new ItemStack((Block)ModBlocks.ORE2, count, i);
        }
        throw new InvalidParameterException("The ore block " + name + " could not be found.");
    }

    public static ItemStack getOreByName(String name) {
        return BlockOre2.getOreByName(name, 1);
    }

    public IBlockState getBlockStateFromName(String name) {
        int index = -1;
        for (int i = 0; i < ores.length; ++i) {
            if (!ores[i].equalsIgnoreCase(name)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            throw new InvalidParameterException("The ore block " + name + " could not be found.");
        }
        return this.getStateFromMeta(index);
    }

    protected boolean canSilkHarvest() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item item, CreativeTabs creativeTabs, List<ItemStack> list) {
        for (int meta = 0; meta < ores.length; ++meta) {
            list.add(new ItemStack(item, 1, meta));
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.getMetaFromState(state));
    }

    public int damageDropped(IBlockState state) {
        return this.getMetaFromState(state);
    }

    public IBlockState getStateFromMeta(int meta) {
        if (meta > ores.length) {
            meta = 0;
        }
        return this.getBlockState().getBaseState().withProperty((IProperty)this.VARIANTS, (Comparable)((Object)oreNamesList.get(meta)));
    }

    public int getMetaFromState(IBlockState state) {
        return oreNamesList.indexOf(state.getValue((IProperty)this.VARIANTS));
    }

    protected BlockStateContainer createBlockState() {
        this.VARIANTS = new PropertyString("type", oreNamesList);
        return new BlockStateContainer((Block)this, new IProperty[]{this.VARIANTS});
    }

    @Override
    public String getUserLoclisedName(IBlockState state) {
        return StringUtils.toFirstCapital((String)oreNamesList.get(this.getMetaFromState(state)));
    }
}

