/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks.generator;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import reborncore.common.BaseTileBlock;
import techreborn.client.TechRebornCreativeTab;
import techreborn.tiles.generator.TileSolarPanel;

public class BlockSolarPanel
extends BaseTileBlock {
    public static PropertyBool ACTIVE = PropertyBool.create((String)"active");
    private final String prefix = "techreborn:blocks/machine/generators/";

    public BlockSolarPanel() {
        super(Material.IRON);
        this.setUnlocalizedName("techreborn.solarpanel");
        this.setCreativeTab(TechRebornCreativeTab.instance);
        this.setDefaultState(this.getDefaultState().withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
        this.setHardness(2.0f);
    }

    protected BlockStateContainer createBlockState() {
        ACTIVE = PropertyBool.create((String)"active");
        return new BlockStateContainer((Block)this, new IProperty[]{ACTIVE});
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(meta != 0));
    }

    public int getMetaFromState(IBlockState state) {
        return (Boolean)state.getValue((IProperty)ACTIVE) != false ? 1 : 0;
    }

    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return new TileSolarPanel();
    }

    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock) {
        if (worldIn.canBlockSeeSky(pos.up()) && !worldIn.isRaining() && !worldIn.isThundering() && worldIn.isDaytime()) {
            worldIn.setBlockState(pos, worldIn.getBlockState(pos).withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(true)));
        } else {
            worldIn.setBlockState(pos, worldIn.getBlockState(pos).withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
        }
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (!worldIn.isRemote) {
            if (worldIn.canBlockSeeSky(pos.up()) && !worldIn.isRaining() && !worldIn.isThundering() && worldIn.isDaytime()) {
                return this.getDefaultState().withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(true));
            }
            return this.getDefaultState().withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false));
        }
        return this.getDefaultState().withProperty((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false));
    }
}

