/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks.iron_machines;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.blocks.IRotationTexture;
import techreborn.Core;
import techreborn.client.EGui;
import techreborn.client.TechRebornCreativeTab;
import techreborn.tiles.TileIronFurnace;

public class BlockIronFurnace
extends BlockMachineBase
implements IRotationTexture {
    private final String prefix = "techreborn:blocks/machine/iron_machines/";

    public BlockIronFurnace() {
        this.setUnlocalizedName("techreborn.ironfurnace");
        this.setCreativeTab(TechRebornCreativeTab.instance);
    }

    public TileEntity createNewTileEntity(World world, int p_149915_2_) {
        return new TileIronFurnace();
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!player.isSneaking()) {
            player.openGui((Object)Core.INSTANCE, EGui.IRON_FURNACE.ordinal(), world, x, y, z);
        }
        return true;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(new ItemStack((Block)this));
        return items;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (this.isActive(state)) {
            EnumFacing enumfacing = (EnumFacing)state.getValue((IProperty)BlockMachineBase.FACING);
            double d0 = (double)pos.getX() + 0.5;
            double d1 = (double)pos.getY() + rand.nextDouble() * 6.0 / 16.0;
            double d2 = (double)pos.getZ() + 0.5;
            double d3 = 0.52;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            switch (enumfacing) {
                case WEST: {
                    worldIn.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, d0 - 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.spawnParticle(EnumParticleTypes.FLAME, d0 - 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case EAST: {
                    worldIn.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.spawnParticle(EnumParticleTypes.FLAME, d0 + 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case NORTH: {
                    worldIn.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 - 0.52, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.spawnParticle(EnumParticleTypes.FLAME, d0 + d4, d1, d2 - 0.52, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case SOUTH: {
                    worldIn.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 + 0.52, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.spawnParticle(EnumParticleTypes.FLAME, d0 + d4, d1, d2 + 0.52, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    public String getFrontOff() {
        return this.prefix + "iron_furnace_front_off";
    }

    public String getFrontOn() {
        return this.prefix + "iron_furnace_front_on";
    }

    public String getSide() {
        return this.prefix + "iron_machine_side";
    }

    public String getTop() {
        return this.prefix + "iron_machine_top";
    }

    public String getBottom() {
        return this.prefix + "iron_machine_bottom";
    }
}

