/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks.machine;

import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.blocks.IAdvancedRotationTexture;
import techreborn.Core;
import techreborn.client.EGui;
import techreborn.client.TechRebornCreativeTab;
import techreborn.tiles.multiblock.TileVacuumFreezer;

public class BlockVacuumFreezer
extends BlockMachineBase
implements IAdvancedRotationTexture {
    private final String prefix = "techreborn:blocks/machine/greg_machines/";

    public BlockVacuumFreezer(Material material) {
        this.setUnlocalizedName("techreborn.vacuumfreezer");
        this.setCreativeTab(TechRebornCreativeTab.instance);
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        return new TileVacuumFreezer();
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!player.isSneaking()) {
            player.openGui((Object)Core.INSTANCE, EGui.VACUUM_FREEZER.ordinal(), world, pos.getX(), pos.getY(), pos.getZ());
            return true;
        }
        return false;
    }

    public String getFront(boolean isActive) {
        return this.prefix + "vacuum_freezer_front";
    }

    public String getSide(boolean isActive) {
        return this.prefix + "machine_side";
    }

    public String getTop(boolean isActive) {
        return this.prefix + "vacuum_freezer_top";
    }

    public String getBottom(boolean isActive) {
        return this.prefix + "machine_bottom";
    }
}

