/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.client.gui.slots.BaseSlot;
import reborncore.common.container.RebornContainer;
import techreborn.config.ConfigTechReborn;
import techreborn.tiles.lesu.TileLesu;

public class ContainerLESU
extends RebornContainer {
    public int euOut;
    public int storedEu;
    public int euChange;
    public int connectedBlocks;
    public double euStorage;
    EntityPlayer player;
    TileLesu tile;

    public ContainerLESU(TileLesu tileaesu, EntityPlayer player) {
        int i;
        this.tile = tileaesu;
        this.player = player;
        this.addSlotToContainer((Slot)new BaseSlot((IInventory)tileaesu.inventory, 0, 116, 23));
        this.addSlotToContainer((Slot)new BaseSlot((IInventory)tileaesu.inventory, 1, 116, 59));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer((Slot)new BaseSlot((IInventory)player.inventory, j + i * 9 + 9, 8 + j * 18, 115 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlotToContainer((Slot)new BaseSlot((IInventory)player.inventory, i, 8 + i * 18, 173));
        }
    }

    public boolean canInteractWith(EntityPlayer player) {
        return true;
    }

    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        for (int i = 0; i < this.listeners.size(); ++i) {
            IContainerListener IContainerListener2 = (IContainerListener)this.listeners.get(i);
            if ((double)this.euOut != this.tile.getMaxOutput()) {
                IContainerListener2.sendProgressBarUpdate((Container)this, 0, (int)this.tile.getMaxOutput());
            }
            if ((double)this.storedEu != this.tile.getEnergy()) {
                IContainerListener2.sendProgressBarUpdate((Container)this, 1, (int)this.tile.getEnergy());
            }
            if ((double)this.euChange != this.tile.getEuChange() && this.tile.getEuChange() != -1.0) {
                IContainerListener2.sendProgressBarUpdate((Container)this, 2, (int)this.tile.getEuChange());
            }
            if (this.connectedBlocks == this.tile.connectedBlocks) continue;
            IContainerListener2.sendProgressBarUpdate((Container)this, 3, this.tile.connectedBlocks);
        }
    }

    public void addListener(IContainerListener crafting) {
        super.addListener(crafting);
        crafting.sendProgressBarUpdate((Container)this, 0, (int)this.tile.getMaxOutput());
        crafting.sendProgressBarUpdate((Container)this, 1, (int)this.tile.getEnergy());
        crafting.sendProgressBarUpdate((Container)this, 2, (int)this.tile.getEuChange());
        crafting.sendProgressBarUpdate((Container)this, 3, this.tile.connectedBlocks);
    }

    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int id, int value) {
        if (id == 0) {
            this.euOut = value;
        } else if (id == 1) {
            this.storedEu = value;
        } else if (id == 2) {
            this.euChange = value;
        } else if (id == 3) {
            this.connectedBlocks = value;
        } else if (id == 4) {
            this.euStorage = value;
        }
        this.euStorage = (this.connectedBlocks + 1) * ConfigTechReborn.LesuStoragePerBlock;
    }
}

