/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.container.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import reborncore.common.util.ItemUtils;

public class BuiltContainer
extends Container {
    private final String name;
    private final Predicate<EntityPlayer> canInteract;
    private final List<Range<Integer>> playerSlotRanges;
    private final List<Range<Integer>> tileSlotRanges;
    private final ArrayList<MutableTriple<IntSupplier, IntConsumer, Short>> shortValues;
    private final ArrayList<MutableTriple<IntSupplier, IntConsumer, Integer>> integerValues;
    private List<Consumer<InventoryCrafting>> craftEvents;
    private Integer[] integerParts;

    public BuiltContainer(String name, Predicate<EntityPlayer> canInteract, List<Range<Integer>> playerSlotRange, List<Range<Integer>> tileSlotRange) {
        this.name = name;
        this.canInteract = canInteract;
        this.playerSlotRanges = playerSlotRange;
        this.tileSlotRanges = tileSlotRange;
        this.shortValues = new ArrayList();
        this.integerValues = new ArrayList();
    }

    public void addShortSync(List<Pair<IntSupplier, IntConsumer>> syncables) {
        for (Pair<IntSupplier, IntConsumer> syncable : syncables) {
            this.shortValues.add((MutableTriple<IntSupplier, IntConsumer, Short>)MutableTriple.of((Object)syncable.getLeft(), (Object)syncable.getRight(), (Object)0));
        }
        this.shortValues.trimToSize();
    }

    public void addIntegerSync(List<Pair<IntSupplier, IntConsumer>> syncables) {
        for (Pair<IntSupplier, IntConsumer> syncable : syncables) {
            this.integerValues.add((MutableTriple<IntSupplier, IntConsumer, Integer>)MutableTriple.of((Object)syncable.getLeft(), (Object)syncable.getRight(), (Object)0));
        }
        this.integerValues.trimToSize();
        this.integerParts = new Integer[this.integerValues.size()];
    }

    public void addCraftEvents(List<Consumer<InventoryCrafting>> craftEvents) {
        this.craftEvents = craftEvents;
    }

    public void addSlot(Slot slot) {
        this.addSlotToContainer(slot);
    }

    public boolean canInteractWith(EntityPlayer playerIn) {
        return this.canInteract.test(playerIn);
    }

    public final void onCraftMatrixChanged(IInventory inv) {
        if (!this.craftEvents.isEmpty()) {
            this.craftEvents.forEach(consumer -> consumer.accept((InventoryCrafting)inv));
        }
    }

    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        for (IContainerListener listener : this.listeners) {
            int supplied;
            int i = 0;
            if (!this.shortValues.isEmpty()) {
                for (MutableTriple<IntSupplier, IntConsumer, Short> mutableTriple : this.shortValues) {
                    supplied = ((IntSupplier)mutableTriple.getLeft()).getAsInt();
                    if (supplied != (Short)mutableTriple.getRight()) {
                        listener.sendProgressBarUpdate((Container)this, i, supplied);
                        mutableTriple.setRight((Object)((short)supplied));
                    }
                    ++i;
                }
            }
            if (this.integerValues.isEmpty()) continue;
            for (MutableTriple mutableTriple : this.integerValues) {
                supplied = ((IntSupplier)mutableTriple.getLeft()).getAsInt();
                if (supplied != (Integer)mutableTriple.getRight()) {
                    listener.sendProgressBarUpdate((Container)this, i, supplied >> 16);
                    listener.sendProgressBarUpdate((Container)this, i + 1, (int)((short)(supplied & 0xFFFF)));
                    mutableTriple.setRight((Object)supplied);
                }
                i += 2;
            }
        }
    }

    public void addListener(IContainerListener listener) {
        super.addListener(listener);
        int i = 0;
        if (!this.shortValues.isEmpty()) {
            for (MutableTriple<IntSupplier, IntConsumer, Short> mutableTriple : this.shortValues) {
                short s = (short)((IntSupplier)mutableTriple.getLeft()).getAsInt();
                listener.sendProgressBarUpdate((Container)this, i, (int)s);
                mutableTriple.setRight((Object)s);
                ++i;
            }
        }
        if (!this.integerValues.isEmpty()) {
            for (MutableTriple mutableTriple : this.integerValues) {
                int n = ((IntSupplier)mutableTriple.getLeft()).getAsInt();
                listener.sendProgressBarUpdate((Container)this, i, n >> 16);
                listener.sendProgressBarUpdate((Container)this, i + 1, (int)((short)(n & 0xFFFF)));
                mutableTriple.setRight((Object)n);
                i += 2;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int id, int value) {
        if (id < this.shortValues.size()) {
            ((IntConsumer)this.shortValues.get(id).getMiddle()).accept((short)value);
            this.shortValues.get(id).setRight((Object)((short)value));
        } else if (id - this.shortValues.size() < this.integerValues.size() * 2) {
            if ((id - this.shortValues.size()) % 2 == 0) {
                this.integerParts[(id - this.shortValues.size()) / 2] = value;
            } else {
                ((IntConsumer)this.integerValues.get((id - this.shortValues.size()) / 2).getMiddle()).accept((this.integerParts[(id - this.shortValues.size()) / 2] & 0xFFFF) << 16 | value & 0xFFFF);
            }
        }
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int index) {
        ItemStack originalStack = null;
        Slot slot = (Slot)this.inventorySlots.get(index);
        if (slot != null && slot.getHasStack()) {
            ItemStack stackInSlot = slot.getStack();
            originalStack = stackInSlot.copy();
            boolean shifted = false;
            for (Range<Integer> range : this.playerSlotRanges) {
                if (!range.contains((Object)index)) continue;
                if (!this.shiftToTile(stackInSlot)) break;
                shifted = true;
                break;
            }
            if (!shifted) {
                for (Range<Integer> range : this.tileSlotRanges) {
                    if (!range.contains((Object)index)) continue;
                    if (!this.shiftToPlayer(stackInSlot)) break;
                    shifted = true;
                    break;
                }
            }
            slot.onSlotChange(stackInSlot, originalStack);
            if (stackInSlot.stackSize <= 0) {
                slot.putStack(null);
            } else {
                slot.onSlotChanged();
            }
            if (stackInSlot.stackSize == originalStack.stackSize) {
                return null;
            }
            slot.onPickupFromSlot(player, stackInSlot);
        }
        return originalStack;
    }

    protected boolean shiftItemStack(ItemStack stackToShift, int start, int end) {
        ItemStack stackInSlot;
        Slot slot;
        int slotIndex;
        boolean changed = false;
        if (stackToShift.isStackable()) {
            for (slotIndex = start; stackToShift.stackSize > 0 && slotIndex < end; ++slotIndex) {
                slot = (Slot)this.inventorySlots.get(slotIndex);
                stackInSlot = slot.getStack();
                if (stackInSlot == null || !ItemUtils.isItemEqual((ItemStack)stackInSlot, (ItemStack)stackToShift, (boolean)true, (boolean)true) || !slot.isItemValid(stackToShift)) continue;
                int resultingStackSize = stackInSlot.stackSize + stackToShift.stackSize;
                int max = Math.min(stackToShift.getMaxStackSize(), slot.getSlotStackLimit());
                if (resultingStackSize <= max) {
                    stackToShift.stackSize = 0;
                    stackInSlot.stackSize = resultingStackSize;
                    slot.onSlotChanged();
                    changed = true;
                    continue;
                }
                if (stackInSlot.stackSize >= max) continue;
                stackToShift.stackSize -= max - stackInSlot.stackSize;
                stackInSlot.stackSize = max;
                slot.onSlotChanged();
                changed = true;
            }
        }
        if (stackToShift.stackSize > 0) {
            for (slotIndex = start; stackToShift.stackSize > 0 && slotIndex < end; ++slotIndex) {
                slot = (Slot)this.inventorySlots.get(slotIndex);
                stackInSlot = slot.getStack();
                if (stackInSlot != null || !slot.isItemValid(stackToShift)) continue;
                int max = Math.min(stackToShift.getMaxStackSize(), slot.getSlotStackLimit());
                stackInSlot = stackToShift.copy();
                stackInSlot.stackSize = Math.min(stackToShift.stackSize, max);
                stackToShift.stackSize = -stackInSlot.stackSize;
                slot.putStack(stackInSlot);
                slot.onSlotChanged();
                changed = true;
            }
        }
        return changed;
    }

    private boolean shiftToTile(ItemStack stackToShift) {
        for (Range<Integer> range : this.tileSlotRanges) {
            if (!this.shiftItemStack(stackToShift, (Integer)range.getMinimum(), (Integer)range.getMaximum() + 1)) continue;
            return true;
        }
        return false;
    }

    private boolean shiftToPlayer(ItemStack stackToShift) {
        for (Range<Integer> range : this.playerSlotRanges) {
            if (!this.shiftItemStack(stackToShift, (Integer)range.getMinimum(), (Integer)range.getMaximum() + 1)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }
}

