/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.gui;

import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.gui.TRBuilder;
import techreborn.client.gui.widget.GuiButtonPowerBar;

public class GuiBase
extends GuiContainer {
    public int xSize = 176;
    public int ySize = 176;
    public TRBuilder builder = new TRBuilder();
    public TileEntity tile;
    public BuiltContainer container;

    public GuiBase(EntityPlayer player, TileEntity tile, BuiltContainer container) {
        super((Container)container);
        this.tile = tile;
        this.container = container;
    }

    protected void drawSlot(int x, int y, Layer layer) {
        if (layer == Layer.BACKGROUND) {
            x += this.guiLeft;
            y += this.guiTop;
        }
        this.builder.drawSlot((GuiScreen)this, x - 1, y - 1);
    }

    protected void drawArmourSlots(int x, int y, Layer layer) {
        if (layer == Layer.BACKGROUND) {
            x += this.guiLeft;
            y += this.guiTop;
        }
        this.builder.drawSlot((GuiScreen)this, x - 1, y - 1);
        this.builder.drawSlot((GuiScreen)this, x - 1, y - 1 + 18);
        this.builder.drawSlot((GuiScreen)this, x - 1, y - 1 + 18 + 18);
        this.builder.drawSlot((GuiScreen)this, x - 1, y - 1 + 18 + 18 + 18);
    }

    protected void drawOutputSlot(int x, int y, Layer layer) {
        if (layer == Layer.BACKGROUND) {
            x += this.guiLeft;
            y += this.guiTop;
        }
        this.builder.drawOutputSlot((GuiScreen)this, x - 5, y - 5);
    }

    protected void drawSelectedStack(int x, int y, Layer layer) {
        if (layer == Layer.BACKGROUND) {
            x += this.guiLeft;
            y += this.guiTop;
        }
        this.builder.drawSelectedStack(this, x, y);
    }

    public void initGui() {
        super.initGui();
    }

    protected void drawGuiContainerBackgroundLayer(float p_146976_1_, int mouseX, int mouseY) {
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.builder.drawDefaultBackground((GuiScreen)this, this.guiLeft, this.guiTop, this.xSize, this.ySize);
        this.builder.drawPlayerSlots((GuiScreen)this, this.guiLeft + this.xSize / 2, this.guiTop + 93, true);
    }

    @SideOnly(value=Side.CLIENT)
    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        this.drawTitle();
    }

    protected void drawTitle() {
        this.drawCentredString(I18n.translateToLocal((String)(this.tile.getBlockType().getUnlocalizedName() + ".name")), 6, 0x404040, Layer.FOREGROUND);
    }

    protected void drawCentredString(String string, int y, int colour, Layer layer) {
        this.drawString(string, this.xSize / 2 - this.mc.fontRendererObj.getStringWidth(string) / 2, y, colour, layer);
    }

    protected void drawCentredString(String string, int y, int colour, int modifier, Layer layer) {
        this.drawString(string, this.xSize / 2 - this.mc.fontRendererObj.getStringWidth(string) / 2 + modifier, y, colour, layer);
    }

    protected void drawString(String string, int x, int y, int colour, Layer layer) {
        int factorX = 0;
        int factorY = 0;
        if (layer == Layer.BACKGROUND) {
            factorX = this.guiLeft;
            factorY = this.guiTop;
        }
        this.mc.fontRendererObj.drawString(string, x + factorX, y + factorY, colour);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void addPowerButton(int x, int y, int id, Layer layer) {
        if (id == 0) {
            this.buttonList.clear();
        }
        int factorX = 0;
        int factorY = 0;
        if (layer == Layer.BACKGROUND) {
            factorX = this.guiLeft;
            factorY = this.guiTop;
        }
        this.buttonList.add(new GuiButtonPowerBar(id, x + factorX, y + factorY, this, layer));
    }

    public static enum Layer {
        BACKGROUND,
        FOREGROUND;

    }

    public static enum SlotRender {
        STANDARD,
        OUTPUT,
        NONE,
        SPRITE;

    }
}

