/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.gui;

import java.io.IOException;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import reborncore.client.multiblock.Multiblock;
import reborncore.client.multiblock.MultiblockRenderEvent;
import reborncore.client.multiblock.MultiblockSet;
import reborncore.common.misc.Location;
import techreborn.client.gui.GuiBase;
import techreborn.client.gui.TRBuilder;
import techreborn.client.gui.widget.GuiButtonHologram;
import techreborn.init.ModBlocks;
import techreborn.proxies.ClientProxy;
import techreborn.tiles.multiblock.TileBlastFurnace;

public class GuiBlastFurnace
extends GuiBase {
    public TileBlastFurnace tile;
    boolean hasMultiBlock;

    public GuiBlastFurnace(EntityPlayer player, TileBlastFurnace tile) {
        super(player, (TileEntity)tile, tile.createContainer(player));
        this.tile = tile;
    }

    @Override
    public void initGui() {
        super.initGui();
        this.hasMultiBlock = this.tile.getCachedHeat() != 0;
        ClientProxy.multiblockRenderEvent.setMultiblock(null);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(f, mouseX, mouseY);
        this.hasMultiBlock = this.tile.getCachedHeat() != 0;
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiBase.Layer layer = GuiBase.Layer.BACKGROUND;
        this.drawSlot(50, 27, layer);
        this.drawSlot(50, 47, layer);
        this.drawSlot(92, 36, layer);
        this.drawSlot(110, 36, layer);
        this.builder.drawJEIButton(this, 150, 4, layer);
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        super.drawGuiContainerForegroundLayer(mouseX, mouseY);
        this.hasMultiBlock = this.tile.getCachedHeat() != 0;
        GuiBase.Layer layer = GuiBase.Layer.FOREGROUND;
        this.builder.drawProgressBar(this, this.tile.getProgressScaled(100), 100, 71, 40, mouseX, mouseY, TRBuilder.ProgressDirection.RIGHT, layer);
        this.builder.drawMultiEnergyBar(this, 9, 18, (int)this.tile.getEnergy(), (int)this.tile.getMaxPower(), mouseX, mouseY, 0, layer);
        this.builder.drawBigHeatBar(this, 31, 71, this.tile.getCachedHeat(), 3230, layer);
        if (this.hasMultiBlock) {
            this.addHologramButton(6, 4, 212, layer);
            this.builder.drawHologramButton(this, 6, 4, mouseX, mouseY, layer);
        } else {
            this.builder.drawMultiblockMissingBar(this, layer);
            this.addHologramButton(76, 56, 212, layer);
            this.builder.drawHologramButton(this, 76, 56, mouseX, mouseY, layer);
        }
    }

    public void addHologramButton(int x, int y, int id, GuiBase.Layer layer) {
        if (id == 0) {
            this.buttonList.clear();
        }
        int factorX = 0;
        int factorY = 0;
        if (layer == GuiBase.Layer.BACKGROUND) {
            factorX = this.guiLeft;
            factorY = this.guiTop;
        }
        this.buttonList.add(new GuiButtonHologram(id, x + factorX, y + factorY, this, layer));
    }

    public void actionPerformed(GuiButton button) throws IOException {
        super.actionPerformed(button);
        if (button.id == 212) {
            if (ClientProxy.multiblockRenderEvent.currentMultiblock == null) {
                Multiblock multiblock = new Multiblock();
                this.addComponent(0, 0, 0, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(1, 0, 0, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(0, 0, 1, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(-1, 0, 0, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(0, 0, -1, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(-1, 0, -1, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(-1, 0, 1, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(1, 0, -1, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(1, 0, 1, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(1, 1, 0, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(0, 1, 1, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(-1, 1, 0, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(0, 1, -1, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(-1, 1, -1, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(-1, 1, 1, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(1, 1, -1, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(1, 1, 1, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(1, 2, 0, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(0, 2, 1, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(-1, 2, 0, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(0, 2, -1, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(-1, 2, -1, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(-1, 2, 1, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(1, 2, -1, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(1, 2, 1, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(0, 3, 0, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(1, 3, 0, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(0, 3, 1, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(-1, 3, 0, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(0, 3, -1, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(-1, 3, -1, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(-1, 3, 1, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(1, 3, -1, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                this.addComponent(1, 3, 1, ModBlocks.MACHINE_CASINGS.getDefaultState(), multiblock);
                MultiblockSet set = new MultiblockSet(multiblock);
                ClientProxy.multiblockRenderEvent.setMultiblock(set);
                ClientProxy.multiblockRenderEvent.parent = new Location(this.tile.getPos().getX(), this.tile.getPos().getY(), this.tile.getPos().getZ(), this.tile.getWorld());
                MultiblockRenderEvent.anchor = new BlockPos(this.tile.getPos().getX() - EnumFacing.getFront((int)this.tile.getFacingInt()).getFrontOffsetX() * 2, this.tile.getPos().getY() - 1, this.tile.getPos().getZ() - EnumFacing.getFront((int)this.tile.getFacingInt()).getFrontOffsetZ() * 2);
            } else {
                ClientProxy.multiblockRenderEvent.setMultiblock(null);
            }
        }
    }

    public void addComponent(int x, int y, int z, IBlockState blockState, Multiblock multiblock) {
        multiblock.addComponent(new BlockPos(x, y, z), blockState);
    }
}

