/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.gui;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import reborncore.client.multiblock.MultiblockRenderEvent;
import reborncore.client.multiblock.MultiblockSet;
import reborncore.common.misc.Location;
import reborncore.common.powerSystem.PowerSystem;
import techreborn.client.ClientMultiBlocks;
import techreborn.proxies.ClientProxy;
import techreborn.tiles.fusionReactor.TileEntityFusionController;

public class GuiFusionReactor
extends GuiContainer {
    public static final ResourceLocation texture = new ResourceLocation("techreborn", "textures/gui/fusion_reactor.png");
    TileEntityFusionController fusionController;

    public GuiFusionReactor(EntityPlayer player, TileEntityFusionController fusion) {
        super((Container)fusion.createContainer(player));
        this.fusionController = fusion;
    }

    protected void drawGuiContainerForegroundLayer(int p_146979_1_, int p_146979_2_) {
        String name = I18n.translateToLocal((String)"tile.techreborn.fusioncontrolcomputer.name");
        this.fontRendererObj.drawString(name, 87, 6, 0x404040);
        this.fontRendererObj.drawString(I18n.translateToLocalFormatted((String)"container.inventory", (Object[])new Object[0]), 8, this.ySize - 96 + 2, 0x404040);
        this.fontRendererObj.drawString(PowerSystem.getLocaliszedPower((double)this.fusionController.getEnergy()), 11, 8, 0xFAFAFF);
        this.fontRendererObj.drawString("Coils: " + (this.fusionController.getCoilStatus() == 1 ? "Yes" : "No"), 11, 16, 0xFAFAFF);
        if (this.fusionController.getNeededPower() > 1 && this.fusionController.getCrafingTickTime() < 1) {
            this.fontRendererObj.drawString("Start: " + this.percentage(this.fusionController.getNeededPower(), (int)this.fusionController.getEnergy()) + "%", 11, 24, 0xFAFAFF);
        }
    }

    public void initGui() {
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        GuiButton button = new GuiButton(212, k + this.xSize - 24, l + 4, 20, 20, "");
        this.buttonList.add(button);
        super.initGui();
        BlockPos coordinates = new BlockPos(this.fusionController.getPos().getX() - EnumFacing.getFront((int)this.fusionController.getFacingInt()).getFrontOffsetX() * 2, this.fusionController.getPos().getY() - 1, this.fusionController.getPos().getZ() - EnumFacing.getFront((int)this.fusionController.getFacingInt()).getFrontOffsetZ() * 2);
        if (coordinates.equals((Object)MultiblockRenderEvent.anchor)) {
            ClientProxy.multiblockRenderEvent.setMultiblock(null);
            button.displayString = "B";
        } else {
            button.displayString = "A";
        }
    }

    protected void drawGuiContainerBackgroundLayer(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.getTextureManager().bindTexture(texture);
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(k, l, 0, 0, this.xSize, this.ySize);
        this.drawTexturedModalRect(k + 88, l + 36, 176, 0, 14, 14);
        this.drawTexturedModalRect(k + 111, l + 34, 176, 14, this.fusionController.getProgressScaled(), 16);
    }

    public int percentage(int MaxValue, int CurrentValue) {
        if (CurrentValue == 0) {
            return 0;
        }
        return (int)((float)CurrentValue * 100.0f / (float)MaxValue);
    }

    public void actionPerformed(GuiButton button) throws IOException {
        super.actionPerformed(button);
        if (button.id == 212) {
            if (ClientProxy.multiblockRenderEvent.currentMultiblock == null) {
                MultiblockSet set = new MultiblockSet(ClientMultiBlocks.reactor);
                ClientProxy.multiblockRenderEvent.setMultiblock(set);
                ClientProxy.multiblockRenderEvent.parent = new Location(this.fusionController.getPos().getX(), this.fusionController.getPos().getY(), this.fusionController.getPos().getZ(), this.fusionController.getWorld());
                MultiblockRenderEvent.anchor = new BlockPos(this.fusionController.getPos().getX(), this.fusionController.getPos().getY() - 1, this.fusionController.getPos().getZ());
                button.displayString = "A";
            } else {
                ClientProxy.multiblockRenderEvent.setMultiblock(null);
                button.displayString = "B";
            }
        }
    }
}

