/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.gui;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.FluidStack;
import techreborn.tiles.multiblock.TileIndustrialSawmill;

public class GuiIndustrialSawmill
extends GuiContainer {
    public static final ResourceLocation texture = new ResourceLocation("techreborn", "textures/gui/industrial_sawmill.png");
    TileIndustrialSawmill sawmill;

    public GuiIndustrialSawmill(EntityPlayer player, TileIndustrialSawmill sawmill) {
        super((Container)sawmill.createContainer(player));
        this.xSize = 176;
        this.ySize = 167;
        this.sawmill = sawmill;
    }

    public void initGui() {
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        super.initGui();
    }

    protected void drawGuiContainerBackgroundLayer(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.getTextureManager().bindTexture(texture);
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(k, l, 0, 0, this.xSize, this.ySize);
        int progress = this.sawmill.getProgressScaled(24);
        this.drawTexturedModalRect(k + 56, l + 38, 176, 14, progress - 1, 11);
        int energy = 13 - (int)(this.sawmill.getEnergy() / this.sawmill.getMaxPower() * 13.0);
        this.drawTexturedModalRect(k + 36, l + 66 + energy, 179, 1 + energy, 7, 13 - energy);
        if (!this.sawmill.tank.isEmpty()) {
            this.drawFluid(this.sawmill.tank.getFluid(), k + 11, l + 66, 12, 47, this.sawmill.tank.getCapacity());
            int j = this.sawmill.getEnergyScaled(12);
            if (j > 0) {
                this.drawTexturedModalRect(k + 33, l + 65 + 12 - j, 176, 12 - j, 14, j + 2);
            }
            if (!this.sawmill.getMutliBlock()) {
                this.fontRendererObj.drawString(I18n.translateToLocal((String)"techreborn.message.missingmultiblock"), k + 38, l + 52 + 12, -1);
            }
        }
    }

    public void drawFluid(FluidStack fluid, int x, int y, int width, int height, int maxCapacity) {
        int curHeight;
        this.mc.renderEngine.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
        ResourceLocation still = fluid.getFluid().getStill(fluid);
        TextureAtlasSprite sprite = this.mc.getTextureMapBlocks().getAtlasSprite(still.toString());
        int drawHeight = (int)((float)fluid.amount / ((float)maxCapacity * 1.0f) * (float)height);
        int iconHeight = sprite.getIconHeight();
        int iteration = 0;
        for (int offsetHeight = drawHeight; offsetHeight != 0; offsetHeight -= curHeight) {
            curHeight = offsetHeight < iconHeight ? offsetHeight : iconHeight;
            this.drawTexturedModalRect(x, y - offsetHeight, sprite, width, curHeight);
            if (++iteration <= 50) continue;
            break;
        }
    }

    protected void drawGuiContainerForegroundLayer(int p_146979_1_, int p_146979_2_) {
        String name = I18n.translateToLocal((String)"tile.techreborn.industrialsawmill.name");
        this.fontRendererObj.drawString(name, this.xSize / 2 - this.fontRendererObj.getStringWidth(name) / 2, 6, 0x404040);
        this.fontRendererObj.drawString(I18n.translateToLocalFormatted((String)"container.inventory", (Object[])new Object[0]), 58, this.ySize - 96 + 2, 0x404040);
    }
}

