/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.gui;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.Loader;
import reborncore.client.guibuilder.GuiBuilder;
import reborncore.common.powerSystem.PowerSystem;
import techreborn.client.gui.GuiBase;
import techreborn.proxies.ClientProxy;

public class TRBuilder
extends GuiBuilder {
    public static final ResourceLocation GUI_SHEET = new ResourceLocation("techreborn".toLowerCase() + ":textures/gui/gui_sheet.png");

    public TRBuilder() {
        super(GUI_SHEET);
    }

    public void drawMultiEnergyBar(GuiBase gui, int x, int y, int energyStored, int maxEnergyStored, int mouseX, int mouseY, int buttonID, GuiBase.Layer layer) {
        if (layer == GuiBase.Layer.BACKGROUND) {
            x += gui.guiLeft;
            y += gui.guiTop;
        }
        if (layer == GuiBase.Layer.FOREGROUND) {
            mouseX -= gui.guiLeft;
            mouseY -= gui.guiTop;
        }
        Minecraft.getMinecraft().getTextureManager().bindTexture(GUI_SHEET);
        gui.drawTexturedModalRect(x, y, PowerSystem.getDisplayPower().xBar - 15, PowerSystem.getDisplayPower().yBar - 1, 14, 50);
        int draw = (int)((double)energyStored / (double)maxEnergyStored * 48.0);
        if (energyStored > maxEnergyStored) {
            draw = (int)((double)maxEnergyStored / (double)maxEnergyStored * 48.0);
        }
        gui.drawTexturedModalRect(x + 1, y + 49 - draw, PowerSystem.getDisplayPower().xBar, 48 + PowerSystem.getDisplayPower().yBar - draw, 12, draw);
        int percentage = this.percentage(maxEnergyStored, energyStored);
        if (this.isInRect(x + 1, y + 1, 11, 48, mouseX, mouseY)) {
            GlStateManager.disableLighting();
            GlStateManager.disableDepth();
            GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            GuiUtils.drawGradientRect((int)0, (int)(x + 1), (int)(y + 1), (int)(x + 13), (int)(y + 49), (int)-2130706433, (int)-2130706433);
            GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.enableDepth();
            ArrayList<String> list = new ArrayList<String>();
            TextFormatting powerColour = TextFormatting.GOLD;
            list.add(powerColour + PowerSystem.getLocaliszedPowerFormattedNoSuffix((int)energyStored) + "/" + PowerSystem.getLocaliszedPowerFormattedNoSuffix((int)maxEnergyStored) + " " + PowerSystem.getDisplayPower().abbreviation);
            list.add(this.getPercentageColour(percentage) + "" + percentage + "%" + TextFormatting.GRAY + " Charged");
            GuiUtils.drawHoveringText(list, (int)mouseX, (int)mouseY, (int)gui.width, (int)gui.height, (int)-1, (FontRenderer)gui.mc.fontRendererObj);
            GlStateManager.disableLighting();
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        gui.addPowerButton(x, y, buttonID, layer);
    }

    public void drawProgressBar(GuiBase gui, int progress, int maxProgress, int x, int y, int mouseX, int mouseY, ProgressDirection direction, GuiBase.Layer layer) {
        int j;
        if (layer == GuiBase.Layer.BACKGROUND) {
            x += gui.guiLeft;
            y += gui.guiTop;
        }
        if (layer == GuiBase.Layer.FOREGROUND) {
            mouseX -= gui.guiLeft;
            mouseY -= gui.guiTop;
        }
        gui.mc.getTextureManager().bindTexture(GUI_SHEET);
        gui.drawTexturedModalRect(x, y, direction.x, direction.y, direction.width, direction.height);
        if (direction.equals((Object)ProgressDirection.RIGHT)) {
            j = (int)((double)progress / (double)maxProgress * 16.0);
            if (j < 0) {
                j = 0;
            }
            gui.drawTexturedModalRect(x, y, direction.xActive, direction.yActive, j, 10);
        }
        if (direction.equals((Object)ProgressDirection.LEFT)) {
            j = (int)((double)progress / (double)maxProgress * 16.0);
            if (j < 0) {
                j = 0;
            }
            gui.drawTexturedModalRect(x + 16 - j, y, direction.xActive + 16 - j, direction.yActive, j, 10);
        }
        if (this.isInRect(x, y, direction.width, direction.height, mouseX, mouseY)) {
            int percentage = this.percentage(maxProgress, progress);
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.getPercentageColour(percentage) + "" + percentage + "%");
            GuiUtils.drawHoveringText(list, (int)mouseX, (int)mouseY, (int)gui.width, (int)gui.height, (int)-1, (FontRenderer)gui.mc.fontRendererObj);
            GlStateManager.disableLighting();
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void drawTank(GuiBase gui, int x, int y, int mouseX, int mouseY, FluidStack fluid, int maxCapacity, boolean isTankEmpty, GuiBase.Layer layer) {
        if (layer == GuiBase.Layer.BACKGROUND) {
            x += gui.guiLeft;
            y += gui.guiTop;
        }
        if (layer == GuiBase.Layer.FOREGROUND) {
            mouseX -= gui.guiLeft;
            mouseY -= gui.guiTop;
        }
        int percentage = 0;
        int amount = 0;
        boolean empty = true;
        if (!isTankEmpty) {
            amount = fluid.amount;
            percentage = this.percentage(maxCapacity, amount);
            empty = false;
        }
        gui.mc.getTextureManager().bindTexture(GUI_SHEET);
        gui.drawTexturedModalRect(x, y, 228, 18, 22, 56);
        if (!empty) {
            this.drawFluid(gui, fluid, x + 4, y + 4, 14, 48, maxCapacity);
        }
        gui.drawTexturedModalRect(x + 3, y + 3, 231, 74, 16, 50);
        if (this.isInRect(x, y, 22, 56, mouseX, mouseY)) {
            ArrayList<String> list = new ArrayList<String>();
            if (empty) {
                list.add(TextFormatting.GOLD + "Empty Tank");
            } else {
                list.add(TextFormatting.GOLD + "" + amount + "mB/" + maxCapacity + "mB " + fluid.getLocalizedName());
            }
            list.add(this.getPercentageColour(percentage) + "" + percentage + "%" + TextFormatting.GRAY + " Full");
            GuiUtils.drawHoveringText(list, (int)mouseX, (int)mouseY, (int)gui.width, (int)gui.height, (int)-1, (FontRenderer)gui.mc.fontRendererObj);
            GlStateManager.disableLighting();
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void drawFluid(GuiBase gui, FluidStack fluid, int x, int y, int width, int height, int maxCapacity) {
        int curHeight;
        gui.mc.renderEngine.bindTexture(TextureMap.LOCATION_BLOCKS_TEXTURE);
        y += height;
        ResourceLocation still = fluid.getFluid().getStill(fluid);
        TextureAtlasSprite sprite = gui.mc.getTextureMapBlocks().getAtlasSprite(still.toString());
        int drawHeight = (int)((float)fluid.amount / ((float)maxCapacity * 1.0f) * (float)height);
        int iconHeight = sprite.getIconHeight();
        int iteration = 0;
        for (int offsetHeight = drawHeight; offsetHeight != 0; offsetHeight -= curHeight) {
            curHeight = offsetHeight < iconHeight ? offsetHeight : iconHeight;
            gui.drawTexturedModalRect(x, y - offsetHeight, sprite, width, curHeight);
            if (++iteration <= 50) continue;
            break;
        }
        gui.mc.getTextureManager().bindTexture(GUI_SHEET);
    }

    public void drawJEIButton(GuiBase gui, int x, int y, GuiBase.Layer layer) {
        if (Loader.isModLoaded((String)"JEI")) {
            if (layer == GuiBase.Layer.BACKGROUND) {
                x += gui.guiLeft;
                y += gui.guiTop;
            }
            gui.mc.getTextureManager().bindTexture(GUI_SHEET);
            gui.drawTexturedModalRect(x, y, 184, 70, 20, 12);
        }
    }

    public void drawHologramButton(GuiBase gui, int x, int y, int mouseX, int mouseY, GuiBase.Layer layer) {
        if (layer == GuiBase.Layer.BACKGROUND) {
            x += gui.guiLeft;
            y += gui.guiTop;
        }
        if (layer == GuiBase.Layer.FOREGROUND) {
            mouseX -= gui.guiLeft;
            mouseY -= gui.guiTop;
        }
        gui.mc.getTextureManager().bindTexture(GUI_SHEET);
        if (ClientProxy.multiblockRenderEvent.currentMultiblock == null) {
            gui.drawTexturedModalRect(x, y, 184, 94, 20, 12);
        } else {
            gui.drawTexturedModalRect(x, y, 184, 106, 20, 12);
        }
        if (this.isInRect(x, y, 20, 12, mouseX, mouseY)) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("Toggle Multiblock Hologram");
            GlStateManager.pushMatrix();
            GuiUtils.drawHoveringText(list, (int)mouseX, (int)mouseY, (int)gui.width, (int)gui.height, (int)-1, (FontRenderer)gui.mc.fontRendererObj);
            GlStateManager.popMatrix();
        }
    }

    public void drawBigBlueBar(GuiBase gui, int x, int y, int value, int max, int mouseX, int mouseY, String suffix, GuiBase.Layer layer) {
        if (layer == GuiBase.Layer.BACKGROUND) {
            x += gui.guiLeft;
            y += gui.guiTop;
        }
        gui.mc.getTextureManager().bindTexture(GUI_SHEET);
        if (!suffix.equals("")) {
            suffix = " " + suffix;
        }
        gui.drawTexturedModalRect(x, y, 0, 218, 114, 18);
        int j = (int)((double)value / (double)max * 106.0);
        if (j < 0) {
            j = 0;
        }
        gui.drawTexturedModalRect(x + 4, y + 4, 0, 236, j, 10);
        gui.drawCentredString(value + suffix, y + 5, 0xFFFFFF, layer);
        if (this.isInRect(x, y, 114, 18, mouseX, mouseY)) {
            int percentage = this.percentage(max, value);
            ArrayList<String> list = new ArrayList<String>();
            list.add("" + TextFormatting.GOLD + value + "/" + max + suffix);
            list.add(this.getPercentageColour(percentage) + "" + percentage + "%" + TextFormatting.GRAY + " Full");
            if (value > max) {
                list.add(TextFormatting.GRAY + "Yo this is storing more than it should be able to");
                list.add(TextFormatting.GRAY + "prolly a bug");
                list.add(TextFormatting.GRAY + "pls report and tell how tf you did this");
            }
            GuiUtils.drawHoveringText(list, (int)mouseX, (int)mouseY, (int)gui.width, (int)gui.height, (int)-1, (FontRenderer)gui.mc.fontRendererObj);
            GlStateManager.disableLighting();
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void drawBigHeatBar(GuiBase gui, int x, int y, int value, int max, GuiBase.Layer layer) {
        if (layer == GuiBase.Layer.BACKGROUND) {
            x += gui.guiLeft;
            y += gui.guiTop;
        }
        gui.mc.getTextureManager().bindTexture(GUI_SHEET);
        gui.drawTexturedModalRect(x, y, 0, 218, 114, 18);
        if (value != 0) {
            int j = (int)((double)value / (double)max * 106.0);
            if (j < 0) {
                j = 0;
            }
            gui.drawTexturedModalRect(x + 4, y + 4, 0, 246, j, 10);
            gui.drawCentredString(value + " Heat", y + 5, 0xFFFFFF, layer);
        }
    }

    public void drawMultiblockMissingBar(GuiBase gui, GuiBase.Layer layer) {
        int x = 0;
        int y = 4;
        if (layer == GuiBase.Layer.BACKGROUND) {
            x += gui.guiLeft;
            y += gui.guiTop;
        }
        gui.mc.getTextureManager().bindTexture(GUI_SHEET);
        GlStateManager.disableLighting();
        GlStateManager.disableDepth();
        GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        GuiUtils.drawGradientRect((int)0, (int)x, (int)y, (int)(x + 176), (int)(y + 20), (int)0, (int)-1073741824);
        GuiUtils.drawGradientRect((int)0, (int)x, (int)(y + 20), (int)(x + 176), (int)(y + 20 + 48), (int)-1073741824, (int)-1073741824);
        GuiUtils.drawGradientRect((int)0, (int)x, (int)(y + 68), (int)(x + 176), (int)(y + 70 + 20), (int)-1073741824, (int)0);
        GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.enableDepth();
        gui.drawCentredString(I18n.translateToLocal((String)"techreborn.message.missingmultiblock"), 43, 0xFFFFFF, layer);
    }

    public void drawBigBlueBar(GuiBase gui, int x, int y, int value, int max, int mouseX, int mouseY, GuiBase.Layer layer) {
        this.drawBigBlueBar(gui, x, y, value, max, mouseX, mouseY, "", layer);
    }

    public void drawSelectedStack(GuiBase gui, int x, int y) {
        Minecraft.getMinecraft().getTextureManager().bindTexture(GUI_SHEET);
        gui.drawTexturedModalRect(x - 4, y - 4, 202, 44, 24, 24);
    }

    public void drawBurnBar(GuiBase gui, int progress, int maxProgress, int x, int y, int mouseX, int mouseY, GuiBase.Layer layer) {
        if (layer == GuiBase.Layer.BACKGROUND) {
            x += gui.guiLeft;
            y += gui.guiTop;
        }
        if (layer == GuiBase.Layer.FOREGROUND) {
            mouseX -= gui.guiLeft;
            mouseY -= gui.guiTop;
        }
        gui.mc.getTextureManager().bindTexture(GUI_SHEET);
        gui.drawTexturedModalRect(x, y, 171, 84, 13, 13);
        int j = 13 - (int)((double)progress / (double)maxProgress * 13.0);
        if (j > 0) {
            gui.drawTexturedModalRect(x, y + j, 171, 70 + j, 13, 13 - j);
        }
        if (this.isInRect(x, y, 12, 12, mouseX, mouseY)) {
            int percentage = this.percentage(maxProgress, progress);
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.getPercentageColour(percentage) + "" + percentage + "%");
            GuiUtils.drawHoveringText(list, (int)mouseX, (int)mouseY, (int)gui.width, (int)gui.height, (int)-1, (FontRenderer)gui.mc.fontRendererObj);
            GlStateManager.disableLighting();
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void drawSlot(GuiScreen gui, int posX, int posY) {
        Minecraft.getMinecraft().getTextureManager().bindTexture(GUI_SHEET);
        gui.drawTexturedModalRect(posX, posY, 150, 0, 18, 18);
    }

    public void drawOutputSlot(GuiScreen gui, int posX, int posY) {
        Minecraft.getMinecraft().getTextureManager().bindTexture(GUI_SHEET);
        gui.drawTexturedModalRect(posX, posY, 150, 18, 26, 26);
    }

    public int getScaledBurnTime(int scale, int burnTime, int totalBurnTime) {
        return (int)((float)burnTime / (float)totalBurnTime * (float)scale);
    }

    public TextFormatting getPercentageColour(int percentage) {
        if (percentage <= 10) {
            return TextFormatting.RED;
        }
        if (percentage >= 75) {
            return TextFormatting.GREEN;
        }
        return TextFormatting.YELLOW;
    }

    public int percentage(int MaxValue, int CurrentValue) {
        if (CurrentValue == 0) {
            return 0;
        }
        return (int)((float)CurrentValue * 100.0f / (float)MaxValue);
    }

    public static enum ProgressDirection {
        RIGHT(84, 151, 100, 151, 16, 10),
        LEFT(100, 161, 84, 161, 16, 10);

        public int x;
        public int y;
        public int xActive;
        public int yActive;
        public int width;
        public int height;

        private ProgressDirection(int x, int y, int xActive, int yActive, int width, int height) {
            this.x = x;
            this.y = y;
            this.xActive = xActive;
            this.yActive = yActive;
            this.width = width;
            this.height = height;
        }
    }
}

