/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.jei;

import java.awt.Color;
import java.text.NumberFormat;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.FluidStack;
import techreborn.compat.jei.BaseRecipeWrapper;

public class RecipeUtil {
    private static final int color = Color.darkGray.getRGB();

    private RecipeUtil() {
    }

    public static void drawInfo(@Nonnull Minecraft minecraft, int x, int y, double startCost, double euPerTick, int tickTime) {
        FontRenderer fontRendererObj = minecraft.fontRendererObj;
        int lineSpacing = fontRendererObj.FONT_HEIGHT + 1;
        NumberFormat formatter = NumberFormat.getInstance();
        String startCostEU = formatter.format(startCost);
        String startCostString = I18n.translateToLocalFormatted((String)"techreborn.jei.recipe.start.cost", (Object[])new Object[]{startCostEU});
        fontRendererObj.drawString(startCostString, x, y, color);
        RecipeUtil.drawInfo(minecraft, x, y += lineSpacing, euPerTick, tickTime);
    }

    public static void drawInfo(@Nonnull Minecraft minecraft, int x, int y, double euPerTick, int tickTime) {
        FontRenderer fontRendererObj = minecraft.fontRendererObj;
        int lineSpacing = fontRendererObj.FONT_HEIGHT + 1;
        String runningCostString = I18n.translateToLocalFormatted((String)"techreborn.jei.recipe.running.cost", (Object[])new Object[]{euPerTick});
        fontRendererObj.drawString(runningCostString, x, y, color);
        String processingTimeString1 = I18n.translateToLocalFormatted((String)"techreborn.jei.recipe.processing.time.1", (Object[])new Object[]{tickTime});
        fontRendererObj.drawString(processingTimeString1, x, y += lineSpacing, color);
        int seconds = tickTime / 20;
        String processingTimeString2 = I18n.translateToLocalFormatted((String)"techreborn.jei.recipe.processing.time.2", (Object[])new Object[]{seconds});
        fontRendererObj.drawString(processingTimeString2, x + 10, y += lineSpacing, color);
    }

    @Deprecated
    public static void setRecipeItems(@Nonnull IRecipeLayout recipeLayout, @Nonnull BaseRecipeWrapper<?> recipe, @Nullable int[] itemInputSlots, @Nullable int[] itemOutputSlots, @Nullable int[] fluidInputSlots, @Nullable int[] fluidOutputSlots) {
        int i;
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        if (itemInputSlots != null) {
            List<List<ItemStack>> inputs = recipe.getInputs();
            for (i = 0; i < inputs.size() && i < itemInputSlots.length; ++i) {
                int inputSlot = itemInputSlots[i];
                guiItemStacks.set(inputSlot, inputs.get(i));
            }
        }
        if (itemOutputSlots != null) {
            List<ItemStack> outputs = recipe.getOutputs();
            for (i = 0; i < outputs.size() && i < itemOutputSlots.length; ++i) {
                int outputSlot = itemOutputSlots[i];
                guiItemStacks.set(outputSlot, outputs.get(i));
            }
        }
        if (fluidInputSlots != null) {
            List<FluidStack> fluidInputs = recipe.getFluidInputs();
            for (i = 0; i < fluidInputs.size() && i < fluidInputSlots.length; ++i) {
                int inputTank = fluidInputSlots[i];
                guiFluidStacks.set(inputTank, fluidInputs.get(i));
            }
        }
    }

    public static void setRecipeItems(@Nonnull IRecipeLayout recipeLayout, @Nonnull IIngredients ingredients, @Nullable int[] itemInputSlots, @Nullable int[] itemOutputSlots, @Nullable int[] fluidInputSlots, @Nullable int[] fluidOutputSlots) {
        int i;
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        if (itemInputSlots != null) {
            List inputs = ingredients.getInputs(ItemStack.class);
            for (i = 0; i < inputs.size() && i < itemInputSlots.length; ++i) {
                int inputSlot = itemInputSlots[i];
                guiItemStacks.set(inputSlot, (List)inputs.get(i));
            }
        }
        if (itemOutputSlots != null) {
            List outputs = ingredients.getOutputs(ItemStack.class);
            for (i = 0; i < outputs.size() && i < itemOutputSlots.length; ++i) {
                int outputSlot = itemOutputSlots[i];
                guiItemStacks.set(outputSlot, (ItemStack)outputs.get(i));
            }
        }
        if (fluidInputSlots != null) {
            List fluidInputs = ingredients.getInputs(FluidStack.class);
            for (i = 0; i < fluidInputs.size() && i < fluidInputSlots.length; ++i) {
                int inputTank = fluidInputSlots[i];
                guiFluidStacks.set(inputTank, (List)fluidInputs.get(i));
            }
        }
        if (fluidOutputSlots != null) {
            List fluidOutputs = ingredients.getOutputs(FluidStack.class);
            for (i = 0; i < fluidOutputs.size() && i < fluidOutputSlots.length; ++i) {
                int outputTank = fluidOutputSlots[i];
                guiFluidStacks.set(outputTank, (FluidStack)fluidOutputs.get(i));
            }
        }
    }
}

