/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.jei;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.BlankModPlugin;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import mezz.jei.config.Config;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import reborncore.api.recipe.RecipeHandler;
import techreborn.Core;
import techreborn.api.generator.EFluidGenerator;
import techreborn.api.generator.FluidGeneratorRecipe;
import techreborn.api.generator.GeneratorRecipeHelper;
import techreborn.api.reactor.FusionReactorRecipeHelper;
import techreborn.api.recipe.BaseRecipe;
import techreborn.api.recipe.machines.AssemblingMachineRecipe;
import techreborn.api.recipe.machines.ImplosionCompressorRecipe;
import techreborn.client.gui.GuiAlloyFurnace;
import techreborn.client.gui.GuiAlloySmelter;
import techreborn.client.gui.GuiAssemblingMachine;
import techreborn.client.gui.GuiBlastFurnace;
import techreborn.client.gui.GuiCentrifuge;
import techreborn.client.gui.GuiChemicalReactor;
import techreborn.client.gui.GuiCompressor;
import techreborn.client.gui.GuiDieselGenerator;
import techreborn.client.gui.GuiElectricFurnace;
import techreborn.client.gui.GuiExtractor;
import techreborn.client.gui.GuiFusionReactor;
import techreborn.client.gui.GuiGasTurbine;
import techreborn.client.gui.GuiGenerator;
import techreborn.client.gui.GuiGrinder;
import techreborn.client.gui.GuiImplosionCompressor;
import techreborn.client.gui.GuiIndustrialElectrolyzer;
import techreborn.client.gui.GuiIndustrialGrinder;
import techreborn.client.gui.GuiIronFurnace;
import techreborn.client.gui.GuiRollingMachine;
import techreborn.client.gui.GuiSemifluidGenerator;
import techreborn.client.gui.GuiThermalGenerator;
import techreborn.client.gui.GuiVacuumFreezer;
import techreborn.compat.CompatManager;
import techreborn.compat.jei.BuiltContainerTransferInfo;
import techreborn.compat.jei.alloySmelter.AlloySmelterRecipeCategory;
import techreborn.compat.jei.alloySmelter.AlloySmelterRecipeHandler;
import techreborn.compat.jei.assemblingMachine.AssemblingMachineRecipeCategory;
import techreborn.compat.jei.assemblingMachine.AssemblingMachineRecipeHandler;
import techreborn.compat.jei.blastFurnace.BlastFurnaceRecipeCategory;
import techreborn.compat.jei.blastFurnace.BlastFurnaceRecipeHandler;
import techreborn.compat.jei.centrifuge.CentrifugeRecipeCategory;
import techreborn.compat.jei.centrifuge.CentrifugeRecipeHandler;
import techreborn.compat.jei.chemicalReactor.ChemicalReactorRecipeCategory;
import techreborn.compat.jei.chemicalReactor.ChemicalReactorRecipeHandler;
import techreborn.compat.jei.compressor.CompressorRecipeCategory;
import techreborn.compat.jei.compressor.CompressorRecipeHandler;
import techreborn.compat.jei.extractor.ExtractorRecipeCategory;
import techreborn.compat.jei.extractor.ExtractorRecipeHandler;
import techreborn.compat.jei.fusionReactor.FusionReactorRecipeCategory;
import techreborn.compat.jei.fusionReactor.FusionReactorRecipeHandler;
import techreborn.compat.jei.generators.fluid.FluidGeneratorRecipeCategory;
import techreborn.compat.jei.generators.fluid.FluidGeneratorRecipeHandler;
import techreborn.compat.jei.grinder.GrinderRecipeCategory;
import techreborn.compat.jei.grinder.GrinderRecipeHandler;
import techreborn.compat.jei.implosionCompressor.ImplosionCompressorRecipeCategory;
import techreborn.compat.jei.implosionCompressor.ImplosionCompressorRecipeHandler;
import techreborn.compat.jei.industrialElectrolyzer.IndustrialElectrolyzerRecipeCategory;
import techreborn.compat.jei.industrialElectrolyzer.IndustrialElectrolyzerRecipeHandler;
import techreborn.compat.jei.industrialGrinder.IndustrialGrinderRecipeCategory;
import techreborn.compat.jei.industrialGrinder.IndustrialGrinderRecipeHandler;
import techreborn.compat.jei.rollingMachine.RollingMachineRecipeCategory;
import techreborn.compat.jei.rollingMachine.RollingMachineRecipeHandler;
import techreborn.compat.jei.rollingMachine.RollingMachineRecipeMaker;
import techreborn.compat.jei.scrapbox.ScrapboxRecipeCategory;
import techreborn.compat.jei.scrapbox.ScrapboxRecipeHandler;
import techreborn.compat.jei.vacuumFreezer.VacuumFreezerRecipeCategory;
import techreborn.compat.jei.vacuumFreezer.VacuumFreezerRecipeHandler;
import techreborn.config.ConfigTechReborn;
import techreborn.init.IC2Duplicates;
import techreborn.init.ModBlocks;
import techreborn.init.ModFluids;
import techreborn.init.ModItems;
import techreborn.items.ItemParts;
import techreborn.parts.TechRebornParts;
import techreborn.parts.powerCables.EnumCableType;

@JEIPlugin
public class TechRebornJeiPlugin
extends BlankModPlugin {
    private static void addDebugRecipes(IModRegistry registry) {
        int time;
        int i;
        ItemStack diamondBlock = new ItemStack(Blocks.DIAMOND_BLOCK);
        ItemStack dirtBlock = new ItemStack(Blocks.DIRT);
        ArrayList<BaseRecipe> debugRecipes = new ArrayList<BaseRecipe>();
        for (i = 0; i < 10; ++i) {
            time = (int)Math.round(200.0 + Math.random() * 100.0);
            AssemblingMachineRecipe assemblingMachineRecipe = new AssemblingMachineRecipe(diamondBlock, diamondBlock, dirtBlock, time, 120);
            debugRecipes.add(assemblingMachineRecipe);
        }
        for (i = 0; i < 10; ++i) {
            time = (int)Math.round(200.0 + Math.random() * 100.0);
            ImplosionCompressorRecipe recipe = new ImplosionCompressorRecipe(diamondBlock, diamondBlock, dirtBlock, dirtBlock, time, 120);
            debugRecipes.add(recipe);
        }
        registry.addRecipes(debugRecipes);
    }

    public void register(@Nonnull IModRegistry registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_BERYLLIUM));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_CALCIUM));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_CALCIUM_CARBONATE));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_CHLORITE));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_DEUTERIUM));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_GLYCERYL));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_HELIUM));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_HELIUM_3));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_HELIUMPLASMA));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_HYDROGEN));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_LITHIUM));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_MERCURY));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_METHANE));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_NITROCOAL_FUEL));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_NITROFUEL));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_NITROGEN));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_NITROGENDIOXIDE));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_POTASSIUM));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_SILICON));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_SODIUM));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_SODIUMPERSULFATE));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_TRITIUM));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_WOLFRAMIUM));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_SULFUR));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_SULFURIC_ACID));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_CARBON));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_CARBON_FIBER));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_NITRO_CARBON));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_SODIUM_SULFIDE));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_DIESEL));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_NITRO_DIESEL));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModFluids.BLOCK_OIL));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack(ModItems.MISSING_RECIPE_PLACEHOLDER));
        if (IC2Duplicates.deduplicate()) {
            for (IC2Duplicates duplicate : IC2Duplicates.values()) {
                if (!duplicate.hasIC2Stack()) continue;
                jeiHelpers.getItemBlacklist().addItemToBlacklist(duplicate.getTrStack());
            }
            if (TechRebornParts.cables != null) {
                for (int i = 0; i < EnumCableType.values().length; ++i) {
                    jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack(TechRebornParts.cables, 1, i));
                }
            }
            jeiHelpers.getItemBlacklist().addItemToBlacklist(ItemParts.getPartByName("rubber"));
            jeiHelpers.getItemBlacklist().addItemToBlacklist(ItemParts.getPartByName("rubberSap"));
            jeiHelpers.getItemBlacklist().addItemToBlacklist(ItemParts.getPartByName("electronicCircuit"));
            jeiHelpers.getItemBlacklist().addItemToBlacklist(ItemParts.getPartByName("advancedCircuit"));
            if (!Core.worldGen.config.rubberTreeConfig.shouldSpawn) {
                jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack(ModBlocks.RUBBER_SAPLING));
                jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack(ModBlocks.RUBBER_LOG));
                jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack(ModBlocks.RUBBER_PLANKS));
                jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack(ModBlocks.RUBBER_LEAVES));
                jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack(ModItems.TREE_TAP));
                jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack(ModItems.ELECTRIC_TREE_TAP));
            }
        }
        registry.addRecipeCategories(new IRecipeCategory[]{new AlloySmelterRecipeCategory(guiHelper), new AssemblingMachineRecipeCategory(guiHelper), new BlastFurnaceRecipeCategory(guiHelper), new CentrifugeRecipeCategory(guiHelper), new ChemicalReactorRecipeCategory(guiHelper), new FusionReactorRecipeCategory(guiHelper), new IndustrialGrinderRecipeCategory(guiHelper), new ImplosionCompressorRecipeCategory(guiHelper), new IndustrialElectrolyzerRecipeCategory(guiHelper), new RollingMachineRecipeCategory(guiHelper), new VacuumFreezerRecipeCategory(guiHelper), new GrinderRecipeCategory(guiHelper), new ExtractorRecipeCategory(guiHelper), new CompressorRecipeCategory(guiHelper), new ScrapboxRecipeCategory(guiHelper)});
        for (EFluidGenerator type2 : EFluidGenerator.values()) {
            registry.addRecipeCategories(new IRecipeCategory[]{new FluidGeneratorRecipeCategory(type2, guiHelper)});
        }
        registry.addRecipeHandlers(new IRecipeHandler[]{new AlloySmelterRecipeHandler(jeiHelpers), new AssemblingMachineRecipeHandler(jeiHelpers), new BlastFurnaceRecipeHandler(jeiHelpers), new CentrifugeRecipeHandler(jeiHelpers), new ChemicalReactorRecipeHandler(jeiHelpers), new FusionReactorRecipeHandler(), new IndustrialGrinderRecipeHandler(jeiHelpers), new ImplosionCompressorRecipeHandler(jeiHelpers), new IndustrialElectrolyzerRecipeHandler(jeiHelpers), new RollingMachineRecipeHandler(), new VacuumFreezerRecipeHandler(jeiHelpers), new GrinderRecipeHandler(jeiHelpers), new ExtractorRecipeHandler(jeiHelpers), new CompressorRecipeHandler(jeiHelpers), new ScrapboxRecipeHandler(jeiHelpers), new FluidGeneratorRecipeHandler(jeiHelpers)});
        registry.addRecipes((List)RecipeHandler.recipeList);
        registry.addRecipes(FusionReactorRecipeHelper.reactorRecipes);
        GeneratorRecipeHelper.fluidRecipes.forEach((type, list) -> registry.addRecipes(new ArrayList<FluidGeneratorRecipe>(list.getRecipes())));
        try {
            registry.addRecipes(RollingMachineRecipeMaker.getRecipes(jeiHelpers));
        }
        catch (RuntimeException e) {
            Core.logHelper.error((Object)"Could not register rolling machine recipes. JEI may have changed its internal recipe wrapper locations.");
            e.printStackTrace();
        }
        if (Config.isDebugModeEnabled()) {
            TechRebornJeiPlugin.addDebugRecipes(registry);
        }
        registry.addDescription(ItemParts.getPartByName("rubberSap"), new String[]{I18n.translateToLocal((String)"techreborn.desc.rubberSap")});
        if (!ConfigTechReborn.ScrapboxDispenser) {
            registry.addDescription(new ItemStack(ModItems.SCRAP_BOX), new String[]{I18n.translateToLocal((String)"techreborn.desc.scrapBoxNoDispenser")});
        } else {
            registry.addDescription(new ItemStack(ModItems.SCRAP_BOX), new String[]{I18n.translateToLocal((String)"techreborn.desc.scrapBox")});
        }
        registry.addRecipeClickArea(GuiCentrifuge.class, 150, 4, 20, 12, new String[]{"TechReborn.Centrifuge"});
        registry.addRecipeClickArea(GuiElectricFurnace.class, 150, 4, 20, 12, new String[]{"minecraft.smelting"});
        registry.addRecipeClickArea(GuiGenerator.class, 150, 4, 20, 12, new String[]{"minecraft.fuel"});
        registry.addRecipeClickArea(GuiExtractor.class, 150, 4, 20, 12, new String[]{"TechReborn.Extractor"});
        registry.addRecipeClickArea(GuiCompressor.class, 150, 4, 20, 12, new String[]{"TechReborn.Compressor"});
        registry.addRecipeClickArea(GuiGrinder.class, 150, 4, 20, 12, new String[]{"TechReborn.Grinder"});
        registry.addRecipeClickArea(GuiVacuumFreezer.class, 150, 4, 20, 12, new String[]{"TechReborn.VacuumFreezer"});
        registry.addRecipeClickArea(GuiBlastFurnace.class, 150, 4, 20, 12, new String[]{"TechReborn.BlastFurnace"});
        registry.addRecipeClickArea(GuiChemicalReactor.class, 150, 4, 20, 12, new String[]{"TechReborn.ChemicalReactor"});
        registry.addRecipeClickArea(GuiIndustrialGrinder.class, 150, 4, 20, 12, new String[]{"TechReborn.IndustrialGrinder"});
        registry.addRecipeClickArea(GuiAlloyFurnace.class, 80, 35, 26, 20, new String[]{"TechReborn.AlloySmelter", "minecraft.fuel"});
        registry.addRecipeClickArea(GuiAlloySmelter.class, 80, 35, 26, 20, new String[]{"TechReborn.AlloySmelter"});
        registry.addRecipeClickArea(GuiAssemblingMachine.class, 85, 34, 24, 20, new String[]{"TechReborn.AssemblingMachine"});
        registry.addRecipeClickArea(GuiFusionReactor.class, 111, 34, 27, 19, new String[]{"TechReborn.FusionReactor"});
        registry.addRecipeClickArea(GuiImplosionCompressor.class, 60, 37, 24, 15, new String[]{"TechReborn.ImplosionCompressor"});
        registry.addRecipeClickArea(GuiIndustrialElectrolyzer.class, 72, 37, 33, 14, new String[]{"TechReborn.IndustrialElectrolyzer"});
        registry.addRecipeClickArea(GuiRollingMachine.class, 89, 32, 26, 25, new String[]{"TechReborn.RollingMachine"});
        registry.addRecipeClickArea(GuiIronFurnace.class, 78, 36, 24, 16, new String[]{"minecraft.smelting", "minecraft.fuel"});
        registry.addRecipeClickArea(GuiSemifluidGenerator.class, 79, 34, 18, 18, new String[]{EFluidGenerator.SEMIFLUID.getRecipeID()});
        registry.addRecipeClickArea(GuiDieselGenerator.class, 79, 34, 18, 18, new String[]{EFluidGenerator.DIESEL.getRecipeID()});
        registry.addRecipeClickArea(GuiGasTurbine.class, 79, 34, 18, 18, new String[]{EFluidGenerator.GAS.getRecipeID()});
        registry.addRecipeClickArea(GuiThermalGenerator.class, 79, 34, 18, 18, new String[]{EFluidGenerator.THERMAL.getRecipeID()});
        registry.addRecipeCategoryCraftingItem(new ItemStack(ModBlocks.IRON_FURNACE), new String[]{"minecraft.smelting", "minecraft.fuel"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(ModBlocks.IRON_ALLOY_FURNACE), new String[]{"TechReborn.AlloySmelter", "minecraft.fuel"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(ModBlocks.SOLID_FUEL_GENEREATOR), new String[]{"minecraft.fuel"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(ModBlocks.COMPRESSOR), new String[]{"TechReborn.Compressor"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(ModBlocks.EXTRACTOR), new String[]{"TechReborn.Extractor"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(ModBlocks.GRINDER), new String[]{"TechReborn.Grinder"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(ModBlocks.VACUUM_FREEZER), new String[]{"TechReborn.VacuumFreezer"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(ModBlocks.ELECTRIC_FURNACE), new String[]{"minecraft.smelting"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(ModBlocks.ALLOY_SMELTER), new String[]{"TechReborn.AlloySmelter"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(ModBlocks.ASSEMBLY_MACHINE), new String[]{"TechReborn.AssemblingMachine"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(ModBlocks.INDUSTRIAL_BLAST_FURNACE), new String[]{"TechReborn.BlastFurnace"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(ModBlocks.INDUSTRIAL_CENTRIFUGE), new String[]{"TechReborn.Centrifuge"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(ModBlocks.CHEMICAL_REACTOR), new String[]{"TechReborn.ChemicalReactor"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(ModBlocks.FUSION_CONTROL_COMPUTER), new String[]{"TechReborn.FusionReactor"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(ModBlocks.IMPLOSION_COMPRESSOR), new String[]{"TechReborn.ImplosionCompressor"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(ModBlocks.INDUSTRIAL_ELECTROLYZER), new String[]{"TechReborn.IndustrialElectrolyzer"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(ModBlocks.INDUSTRIAL_GRINDER), new String[]{"TechReborn.IndustrialGrinder"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(ModBlocks.ROLLING_MACHINE), new String[]{"TechReborn.RollingMachine"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(ModItems.SCRAP_BOX), new String[]{"TechReborn.Scrapbox"});
        registry.addRecipeCategoryCraftingItem(new ItemStack(ModBlocks.SEMIFLUID_GENERATOR), new String[]{EFluidGenerator.SEMIFLUID.getRecipeID()});
        registry.addRecipeCategoryCraftingItem(new ItemStack(ModBlocks.GAS_TURBINE), new String[]{EFluidGenerator.GAS.getRecipeID()});
        registry.addRecipeCategoryCraftingItem(new ItemStack(ModBlocks.DIESEL_GENERATOR), new String[]{EFluidGenerator.DIESEL.getRecipeID()});
        registry.addRecipeCategoryCraftingItem(new ItemStack(ModBlocks.THERMAL_GENERATOR), new String[]{EFluidGenerator.THERMAL.getRecipeID()});
        IRecipeTransferRegistry recipeTransferRegistry = registry.getRecipeTransferRegistry();
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("fusionreactor", "TechReborn.FusionReactor", 36, 2, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("industrialelectrolyzer", "TechReborn.IndustrialElectrolyzer", 36, 2, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("industrialgrinder", "TechReborn.Grinder", 36, 2, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("implosioncompressor", "TechReborn.ImplosionCompressor", 36, 2, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("vacuumfreezer", "TechReborn.VacuumFreezer", 36, 1, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("blastfurnace", "TechReborn.BlastFurnace", 36, 2, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("rollingmachine", "TechReborn.RollingMachine", 36, 9, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("alloyfurnace", "TechReborn.AlloySmelter", 36, 2, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("alloyfurnace", "minecraft.fuel", 36, 2, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("alloysmelter", "TechReborn.AlloySmelter", 36, 2, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("assemblingmachine", "TechReborn.AssemblingMachine", 36, 2, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("chemicalreactor", "TechReborn.ChemicalReactor", 36, 2, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("centrifuge", "TechReborn.Centrifuge", 36, 2, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("grinder", "TechReborn.Grinder", 36, 1, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("extractor", "TechReborn.Extractor", 36, 1, 0, 36));
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new BuiltContainerTransferInfo("compressor", "TechReborn.Compressor", 36, 1, 0, 36));
        if (CompatManager.isQuantumStorageLoaded) {
            registry.getJeiHelpers().getItemBlacklist().addItemToBlacklist(new ItemStack(ModBlocks.QUANTUM_CHEST));
            registry.getJeiHelpers().getItemBlacklist().addItemToBlacklist(new ItemStack(ModBlocks.QUANTUM_TANK));
        }
    }
}

