/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.minetweaker;

import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.ItemStack;
import reborncore.common.util.ItemUtils;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import techreborn.api.reactor.FusionReactorRecipe;
import techreborn.api.reactor.FusionReactorRecipeHelper;
import techreborn.compat.minetweaker.MinetweakerCompat;

@ZenClass(value="mods.techreborn.fusionReactor")
public class MTFusionReactor {
    @ZenMethod
    public static void addRecipe(IIngredient topInput, IIngredient bottomInput, IItemStack output, int startEU, int euTick, int tickTime) {
        FusionReactorRecipe reactorRecipe = new FusionReactorRecipe((ItemStack)MinetweakerCompat.toObject(topInput), (ItemStack)MinetweakerCompat.toObject(bottomInput), MinetweakerCompat.toStack(output), startEU, euTick, tickTime);
        MineTweakerAPI.apply((IUndoableAction)new Add(reactorRecipe));
    }

    @ZenMethod
    public static void removeTopInputRecipe(IIngredient iIngredient) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveTopInput(iIngredient));
    }

    @ZenMethod
    public static void removeBottomInputRecipe(IIngredient iIngredient) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveTopInput(iIngredient));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(MinetweakerCompat.toStack(output)));
    }

    private static class RemoveBottomInput
    implements IUndoableAction {
        private final IIngredient output;
        List<FusionReactorRecipe> removedRecipes = new ArrayList<FusionReactorRecipe>();

        public RemoveBottomInput(IIngredient output) {
            this.output = output;
        }

        public void apply() {
            for (FusionReactorRecipe recipeType : FusionReactorRecipeHelper.reactorRecipes) {
                if (!this.output.matches(MineTweakerMC.getIItemStack((ItemStack)recipeType.getBottomInput()))) continue;
                this.removedRecipes.add(recipeType);
                FusionReactorRecipeHelper.reactorRecipes.remove(recipeType);
                break;
            }
        }

        public void undo() {
            if (this.removedRecipes != null) {
                for (FusionReactorRecipe recipe : this.removedRecipes) {
                    if (recipe == null) continue;
                    FusionReactorRecipeHelper.registerRecipe(recipe);
                }
            }
        }

        public String describe() {
            return "Removing Fusion Reactor recipe";
        }

        public String describeUndo() {
            return "Re-Adding Fusion Reactor recipe";
        }

        public Object getOverrideKey() {
            return null;
        }

        public boolean canUndo() {
            return true;
        }
    }

    private static class RemoveTopInput
    implements IUndoableAction {
        private final IIngredient output;
        List<FusionReactorRecipe> removedRecipes = new ArrayList<FusionReactorRecipe>();

        public RemoveTopInput(IIngredient output) {
            this.output = output;
        }

        public void apply() {
            for (FusionReactorRecipe recipeType : FusionReactorRecipeHelper.reactorRecipes) {
                if (!this.output.matches(MineTweakerMC.getIItemStack((ItemStack)recipeType.getTopInput()))) continue;
                this.removedRecipes.add(recipeType);
                FusionReactorRecipeHelper.reactorRecipes.remove(recipeType);
                break;
            }
        }

        public void undo() {
            if (this.removedRecipes != null) {
                for (FusionReactorRecipe recipe : this.removedRecipes) {
                    if (recipe == null) continue;
                    FusionReactorRecipeHelper.registerRecipe(recipe);
                }
            }
        }

        public String describe() {
            return "Removing Fusion Reactor recipe";
        }

        public String describeUndo() {
            return "Re-Adding Fusion Reactor recipe";
        }

        public Object getOverrideKey() {
            return null;
        }

        public boolean canUndo() {
            return true;
        }
    }

    private static class Remove
    implements IUndoableAction {
        private final ItemStack output;
        List<FusionReactorRecipe> removedRecipes = new ArrayList<FusionReactorRecipe>();

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            for (FusionReactorRecipe recipeType : FusionReactorRecipeHelper.reactorRecipes) {
                if (!ItemUtils.isItemEqual((ItemStack)recipeType.getOutput(), (ItemStack)this.output, (boolean)true, (boolean)false)) continue;
                this.removedRecipes.add(recipeType);
                FusionReactorRecipeHelper.reactorRecipes.remove(recipeType);
                break;
            }
        }

        public void undo() {
            if (this.removedRecipes != null) {
                for (FusionReactorRecipe recipe : this.removedRecipes) {
                    if (recipe == null) continue;
                    FusionReactorRecipeHelper.registerRecipe(recipe);
                }
            }
        }

        public String describe() {
            return "Removing Fusion Reactor recipe for " + this.output.getDisplayName();
        }

        public String describeUndo() {
            return "Re-Adding Fusion Reactor recipe for " + this.output.getDisplayName();
        }

        public Object getOverrideKey() {
            return null;
        }

        public boolean canUndo() {
            return true;
        }
    }

    private static class Add
    implements IUndoableAction {
        private final FusionReactorRecipe recipe;

        public Add(FusionReactorRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            FusionReactorRecipeHelper.registerRecipe(this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            FusionReactorRecipeHelper.reactorRecipes.remove(this.recipe);
        }

        public String describe() {
            return "Adding Fusion Reactor recipe for " + this.recipe.getOutput().getDisplayName();
        }

        public String describeUndo() {
            return "Removing Fusion Reactor recipe for " + this.recipe.getOutput().getDisplayName();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

