/*
 * Decompiled with CFR 0.152.
 */
package techreborn.dev;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.EnumFacing;
import reborncore.RebornCore;
import reborncore.common.blocks.BlockMachineBase;
import techreborn.Core;

public class JsonGenerator {
    public void generate() throws IOException {
        File baseJsonFiles;
        File itemModles;
        File blockModels;
        File models;
        File blockstates;
        File modFolder;
        File assetsFolder;
        File mcDir = new File(".");
        File exportFolder = new File(mcDir, "export");
        if (!exportFolder.exists()) {
            exportFolder.mkdir();
        }
        if (!(assetsFolder = new File(exportFolder, "assets")).exists()) {
            assetsFolder.mkdir();
        }
        if (!(modFolder = new File(assetsFolder, "techreborn")).exists()) {
            modFolder.mkdir();
        }
        if (!(blockstates = new File(modFolder, "blockstates")).exists()) {
            blockstates.mkdir();
        }
        if (!(models = new File(modFolder, "models")).exists()) {
            models.mkdir();
        }
        if (!(blockModels = new File(models, "block")).exists()) {
            blockModels.mkdir();
        }
        if (!(itemModles = new File(models, "item")).exists()) {
            itemModles.mkdir();
        }
        if (!(baseJsonFiles = new File(mcDir, "basejsons")).exists()) {
            Core.logHelper.error((Object)"Could not find base jsons dir!");
            throw new FileNotFoundException();
        }
        File machineBaseFile = new File(baseJsonFiles, "machineBase.json");
        String machineBase = Files.toString((File)machineBaseFile, (Charset)Charsets.UTF_8);
        for (Object object : RebornCore.jsonDestroyer.objectsToDestroy) {
            if (!(object instanceof BlockMachineBase)) continue;
            BlockMachineBase base = (BlockMachineBase)object;
            String name = base.getRegistryName().getResourcePath().replace("tile.techreborn.", "");
            File state = new File(blockstates, name + ".json");
            if (state.exists()) {
                state.delete();
            }
            String output = machineBase;
            output = output.replaceAll("%OFF_TEXTURE%", base.getTextureNameFromState(base.getDefaultState(), EnumFacing.NORTH));
            output = output.replaceAll("%ON_TEXTURE%", base.getTextureNameFromState(base.getDefaultState().withProperty((IProperty)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(true)), EnumFacing.NORTH));
            output = output.replaceAll("%SIDE_TEXTURE%", base.getTextureNameFromState(base.getDefaultState(), EnumFacing.EAST));
            output = output.replaceAll("%TOP_TEXTURE%", base.getTextureNameFromState(base.getDefaultState(), EnumFacing.UP));
            try {
                FileOutputStream is = new FileOutputStream(state);
                OutputStreamWriter osw = new OutputStreamWriter(is);
                BufferedWriter w = new BufferedWriter(osw);
                w.write(output);
                ((Writer)w).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

