/*
 * Decompiled with CFR 0.152.
 */
package techreborn.events;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import techreborn.init.ModItems;
import techreborn.power.PowerTickEvent;

public class TRTickHandler {
    public Item previouslyWearing;
    int ticksCounted = 0;
    long tickTime = 0L;

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onPlayerTick(TickEvent.PlayerTickEvent e) {
        Item chestslot;
        EntityPlayer player = e.player;
        Item item = chestslot = player.getItemStackFromSlot(EntityEquipmentSlot.CHEST) != null ? player.getItemStackFromSlot(EntityEquipmentSlot.CHEST).getItem() : null;
        if (this.previouslyWearing != chestslot && this.previouslyWearing == ModItems.CLOAKING_DEVICE && player.isInvisible() && !player.isPotionActive(MobEffects.INVISIBILITY)) {
            player.setInvisible(false);
        }
        this.previouslyWearing = chestslot;
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent e) {
        if (e.world.isRemote) {
            return;
        }
        long start = System.nanoTime();
        MinecraftForge.EVENT_BUS.post((Event)new PowerTickEvent(e.world));
        long elapsed = System.nanoTime() - start;
        this.tickTime += elapsed;
        ++this.ticksCounted;
        if (this.ticksCounted == 100) {
            this.ticksCounted = 0;
            this.tickTime = 0L;
        }
    }
}

