/*
 * Decompiled with CFR 0.152.
 */
package techreborn.init.recipes;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import reborncore.common.util.OreUtil;
import techreborn.blocks.BlockMachineCasing;
import techreborn.blocks.BlockMachineFrame;
import techreborn.init.IC2Duplicates;
import techreborn.items.ItemCells;
import techreborn.items.ItemDusts;
import techreborn.items.ItemDustsSmall;
import techreborn.items.ItemGems;
import techreborn.items.ItemIngots;
import techreborn.items.ItemNuggets;
import techreborn.items.ItemParts;
import techreborn.items.ItemPlates;
import techreborn.items.ItemUpgrades;
import techreborn.parts.powerCables.ItemStandaloneCables;

public abstract class RecipeMethods {
    static ItemStack getMaterial(String name, int count, Type type) {
        if (type == Type.DUST) {
            return ItemDusts.getDustByName(name, count);
        }
        if (type == Type.SMALL_DUST) {
            return ItemDustsSmall.getSmallDustByName(name, count);
        }
        if (type == Type.INGOT) {
            return ItemIngots.getIngotByName(name, count);
        }
        if (type == Type.GEM) {
            return ItemGems.getGemByName(name, count);
        }
        if (type == Type.PLATE) {
            return ItemPlates.getPlateByName(name, count);
        }
        if (type == Type.NUGGET) {
            return ItemNuggets.getNuggetByName(name, count);
        }
        if (type == Type.CELL) {
            return ItemCells.getCellByName(name, count);
        }
        if (type == Type.PART) {
            return ItemParts.getPartByName(name, count);
        }
        if (type == Type.CABLE) {
            return ItemStandaloneCables.getCableByName(name, count);
        }
        if (type == Type.MACHINE_FRAME) {
            return BlockMachineFrame.getFrameByName(name, count);
        }
        if (type == Type.MACHINE_CASING) {
            return BlockMachineCasing.getStackByName(name, count);
        }
        if (type == Type.UPGRADE) {
            return ItemUpgrades.getUpgradeByName(name, count);
        }
        return null;
    }

    static ItemStack getMaterial(String name, Type type) {
        return RecipeMethods.getMaterial(name, 1, type);
    }

    static ItemStack getOre(String name, int count) {
        return OreUtil.getStackFromName((String)name, (int)count).copy();
    }

    static ItemStack getOre(String name) {
        return RecipeMethods.getOre(name, 1);
    }

    static boolean oresExist(String ... names) {
        for (String name : names) {
            if (!OreDictionary.getOres((String)name).isEmpty()) continue;
            return false;
        }
        return true;
    }

    static ItemStack getStack(Item item) {
        return RecipeMethods.getStack(item, 1);
    }

    static ItemStack getStack(Item item, int count) {
        return RecipeMethods.getStack(item, count, 0);
    }

    static ItemStack getStack(Item item, boolean wildcard) {
        return RecipeMethods.getStack(item, 1, true);
    }

    static ItemStack getStack(Item item, int count, boolean wildcard) {
        return RecipeMethods.getStack(item, count, Short.MAX_VALUE);
    }

    static ItemStack getStack(Item item, int count, int metadata) {
        return new ItemStack(item, count, metadata);
    }

    static ItemStack getStack(Block block) {
        return RecipeMethods.getStack(block, 1);
    }

    static ItemStack getStack(Block block, int count) {
        return RecipeMethods.getStack(block, count, 0);
    }

    static ItemStack getStack(Block block, boolean wildcard) {
        return RecipeMethods.getStack(block, 1, true);
    }

    static ItemStack getStack(Block block, int count, boolean wildcard) {
        return RecipeMethods.getStack(block, count, Short.MAX_VALUE);
    }

    static ItemStack getStack(Block block, int count, int metadata) {
        return RecipeMethods.getStack(Item.getItemFromBlock((Block)block), count, Short.MAX_VALUE);
    }

    static ItemStack getStack(IC2Duplicates ic2Duplicates) {
        return RecipeMethods.getStack(ic2Duplicates, 1);
    }

    static ItemStack getStack(IC2Duplicates ic2Duplicates, int count) {
        ItemStack stack = ic2Duplicates.getStackBasedOnConfig();
        stack.stackSize = count;
        return stack;
    }

    static enum Type {
        DUST,
        SMALL_DUST,
        INGOT,
        NUGGET,
        PLATE,
        GEM,
        CELL,
        PART,
        CABLE,
        MACHINE_FRAME,
        MACHINE_CASING,
        UPGRADE;

    }
}

