/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.client.hud.StackInfoElement;
import reborncore.common.util.ChatUtils;
import reborncore.common.util.Color;
import techreborn.client.TechRebornCreativeTabMisc;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModItems;
import techreborn.items.ItemTRNoDestroy;
import techreborn.lib.MessageIDs;

public class ItemFrequencyTransmitter
extends ItemTRNoDestroy {
    public ItemFrequencyTransmitter() {
        this.setUnlocalizedName("techreborn.frequencyTransmitter");
        this.setCreativeTab(TechRebornCreativeTabMisc.instance);
        this.setMaxStackSize(1);
        this.addPropertyOverride(new ResourceLocation("techreborn:coords"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float apply(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (stack != null && stack.hasTagCompound() && stack.getTagCompound() != null && stack.getTagCompound().hasKey("x") && stack.getTagCompound().hasKey("y") && stack.getTagCompound().hasKey("z") && stack.getTagCompound().hasKey("dim")) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
    }

    public EnumActionResult onItemUse(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        stack.setTagCompound(new NBTTagCompound());
        stack.getTagCompound().setInteger("x", pos.getX());
        stack.getTagCompound().setInteger("y", pos.getY());
        stack.getTagCompound().setInteger("z", pos.getZ());
        stack.getTagCompound().setInteger("dim", world.provider.getDimension());
        if (!world.isRemote && ConfigTechReborn.FreqTransmitterChat) {
            ChatUtils.sendNoSpamMessages((int)MessageIDs.freqTransmitterID, (ITextComponent)new TextComponentString(TextFormatting.GRAY + I18n.translateToLocal((String)"techreborn.message.setTo") + " X: " + TextFormatting.GOLD + pos.getX() + TextFormatting.GRAY + " Y: " + TextFormatting.GOLD + pos.getY() + TextFormatting.GRAY + " Z: " + TextFormatting.GOLD + pos.getZ() + TextFormatting.GRAY + " " + I18n.translateToLocal((String)"techreborn.message.in") + " " + TextFormatting.GOLD + DimensionManager.getProviderType((int)world.provider.getDimension()).getName() + " (" + world.provider.getDimension() + ")"));
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> onItemRightClick(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (player.isSneaking()) {
            stack.setTagCompound(null);
            if (!world.isRemote && ConfigTechReborn.FreqTransmitterChat) {
                ChatUtils.sendNoSpamMessages((int)MessageIDs.freqTransmitterID, (ITextComponent)new TextComponentString(TextFormatting.GRAY + I18n.translateToLocal((String)"techreborn.message.coordsHaveBeen") + " " + TextFormatting.GOLD + I18n.translateToLocal((String)"techreborn.message.cleared")));
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (ConfigTechReborn.FreqTransmitterTooltip) {
            if (stack.hasTagCompound() && stack.getTagCompound() != null && stack.getTagCompound().hasKey("x") && stack.getTagCompound().hasKey("y") && stack.getTagCompound().hasKey("z") && stack.getTagCompound().hasKey("dim")) {
                int x = stack.getTagCompound().getInteger("x");
                int y = stack.getTagCompound().getInteger("y");
                int z = stack.getTagCompound().getInteger("z");
                int dim = stack.getTagCompound().getInteger("dim");
                list.add(TextFormatting.GRAY + "X: " + TextFormatting.GOLD + x);
                list.add(TextFormatting.GRAY + "Y: " + TextFormatting.GOLD + y);
                list.add(TextFormatting.GRAY + "Z: " + TextFormatting.GOLD + z);
                list.add(TextFormatting.DARK_GRAY + DimensionManager.getProviderType((int)dim).getName());
            } else {
                list.add(TextFormatting.GRAY + I18n.translateToLocal((String)"techreborn.message.noCoordsSet"));
            }
        }
    }

    public static class StackInfoFreqTransmitter
    extends StackInfoElement {
        public StackInfoFreqTransmitter() {
            super(ModItems.FREQUENCY_TRANSMITTER);
        }

        public String getText(ItemStack stack) {
            String text = "";
            Color gold = Color.GOLD;
            Color grey = Color.GRAY;
            if (stack.getItem() instanceof ItemFrequencyTransmitter) {
                if (stack.hasTagCompound() && stack.getTagCompound() != null && stack.getTagCompound().hasKey("x") && stack.getTagCompound().hasKey("y") && stack.getTagCompound().hasKey("z") && stack.getTagCompound().hasKey("dim")) {
                    int coordX = stack.getTagCompound().getInteger("x");
                    int coordY = stack.getTagCompound().getInteger("y");
                    int coordZ = stack.getTagCompound().getInteger("z");
                    int coordDim = stack.getTagCompound().getInteger("dim");
                    text = grey + "X: " + gold + coordX + grey + " Y: " + gold + coordY + grey + " Z: " + gold + coordZ + grey + " Dim: " + gold + DimensionManager.getProviderType((int)coordDim).getName() + " (" + coordDim + ")";
                } else {
                    text = grey + I18n.translateToLocal((String)"techreborn.message.noCoordsSet");
                }
            }
            return text;
        }
    }
}

