/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items;

import com.google.common.base.CaseFormat;
import java.security.InvalidParameterException;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import techreborn.client.TechRebornCreativeTabMisc;
import techreborn.init.ModItems;
import techreborn.items.ItemTRNoDestroy;

public class ItemGems
extends ItemTRNoDestroy {
    public static final String[] types = new String[]{"ruby", "sapphire", "peridot", "red_garnet", "yellow_garnet"};

    public ItemGems() {
        this.setCreativeTab(TechRebornCreativeTabMisc.instance);
        this.setUnlocalizedName("techreborn.gem");
        this.setHasSubtypes(true);
    }

    public static ItemStack getGemByName(String name, int count) {
        name = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equalsIgnoreCase(name)) continue;
            return new ItemStack(ModItems.GEMS, count, i);
        }
        throw new InvalidParameterException("The gem " + name + " could not be found.");
    }

    public static ItemStack getGemByName(String name) {
        return ItemGems.getGemByName(name, 1);
    }

    public String getUnlocalizedName(ItemStack itemStack) {
        int meta = itemStack.getItemDamage();
        if (meta < 0 || meta >= types.length) {
            meta = 0;
        }
        return super.getUnlocalizedName() + "." + types[meta];
    }

    public void getSubItems(Item item, CreativeTabs creativeTabs, List list) {
        for (int meta = 0; meta < types.length; ++meta) {
            list.add(new ItemStack(item, 1, meta));
        }
    }
}

