/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items;

import com.google.common.base.CaseFormat;
import java.security.InvalidParameterException;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import techreborn.client.TechRebornCreativeTabMisc;
import techreborn.init.ModItems;
import techreborn.items.ItemTRNoDestroy;

public class ItemNuggets
extends ItemTRNoDestroy {
    public static final String[] types = new String[]{"aluminum", "brass", "bronze", "chrome", "copper", "electrum", "invar", "iridium", "lead", "nickel", "platinum", "silver", "steel", "tin", "titanium", "tungsten", "hot_tungstensteel", "tungstensteel", "zinc", "refined_iron", "PLACEHOLDER_ITEM", "PLACEHOLDER_ITEM", "PLACEHOLDER_ITEM", "iron", "diamond"};

    public ItemNuggets() {
        this.setCreativeTab(TechRebornCreativeTabMisc.instance);
        this.setHasSubtypes(true);
        this.setUnlocalizedName("techreborn.nuggets");
    }

    public static ItemStack getNuggetByName(String name, int count) {
        name = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equalsIgnoreCase(name)) continue;
            return new ItemStack(ModItems.NUGGETS, count, i);
        }
        throw new InvalidParameterException("The nugget " + name + " could not be found.");
    }

    public static ItemStack getNuggetByName(String name) {
        return ItemNuggets.getNuggetByName(name, 1);
    }

    public String getUnlocalizedName(ItemStack itemStack) {
        int meta = itemStack.getItemDamage();
        if (meta < 0 || meta >= types.length) {
            meta = 0;
        }
        return super.getUnlocalizedName() + "." + types[meta];
    }

    public void getSubItems(Item item, CreativeTabs creativeTabs, List list) {
        for (int meta = 0; meta < types.length; ++meta) {
            if (types[meta].equals("PLACEHOLDER_ITEM")) continue;
            list.add(new ItemStack(item, 1, meta));
        }
    }
}

