/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items;

import java.security.InvalidParameterException;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import reborncore.common.recipes.RecipeCrafter;
import techreborn.client.TechRebornCreativeTabMisc;
import techreborn.init.ModItems;
import techreborn.items.ItemTRNoDestroy;
import techreborn.utils.upgrade.IMachineUpgrade;

public class ItemUpgrades
extends ItemTRNoDestroy
implements IMachineUpgrade {
    public static final String[] types = new String[]{"overclock", "transformer", "energy_storage", "range"};

    public ItemUpgrades() {
        this.setUnlocalizedName("techreborn.upgrade");
        this.setHasSubtypes(true);
        this.setCreativeTab(TechRebornCreativeTabMisc.instance);
    }

    public static ItemStack getUpgradeByName(String name, int count) {
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equalsIgnoreCase(name)) continue;
            return new ItemStack(ModItems.UPGRADES, count, i);
        }
        throw new InvalidParameterException("The upgrade " + name + " could not be found.");
    }

    public static ItemStack getUpgradeByName(String name) {
        return ItemUpgrades.getUpgradeByName(name, 1);
    }

    public String getUnlocalizedName(ItemStack itemStack) {
        int meta = itemStack.getItemDamage();
        if (meta < 0 || meta >= types.length) {
            meta = 0;
        }
        return super.getUnlocalizedName() + "." + types[meta];
    }

    public void getSubItems(Item item, CreativeTabs creativeTabs, List list) {
        for (int meta = 0; meta < types.length; ++meta) {
            list.add(new ItemStack(item, 1, meta));
        }
    }

    @Override
    public void processUpgrade(RecipeCrafter crafter, ItemStack stack) {
        if (stack.getItemDamage() == 0) {
            crafter.addSpeedMulti(0.2);
            crafter.addPowerMulti(0.5);
        }
        if (stack.getItemDamage() == 1) {
            crafter.addPowerMulti(-0.2);
        }
        if (stack.getItemDamage() == 2) {
            crafter.addSpeedMulti(0.5);
            crafter.addPowerMulti(1.0);
        }
    }

    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        tooltip.add(TextFormatting.RED + I18n.translateToLocal((String)"tooltip.wip"));
        tooltip.add(TextFormatting.RED + I18n.translateToLocal((String)"tooltip.upBroken"));
        tooltip.add(TextFormatting.RED + I18n.translateToLocal((String)"tooltip.ingredient"));
    }
}

