/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.armor;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.common.powerSystem.PoweredItem;
import techreborn.client.TechRebornCreativeTab;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModItems;

public class ItemLithiumBatpack
extends ItemArmor
implements IEnergyItemInfo {
    public static final int maxCharge = ConfigTechReborn.LithiumBatpackCharge;
    public static final int tier = ConfigTechReborn.LithiumBatpackTier;
    public double transferLimit = 10000.0;

    public ItemLithiumBatpack() {
        super(ItemArmor.ArmorMaterial.DIAMOND, 7, EntityEquipmentSlot.CHEST);
        this.setMaxStackSize(1);
        this.setUnlocalizedName("techreborn.lithiumbatpack");
        this.setCreativeTab(TechRebornCreativeTab.instance);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        for (int i = 0; i < player.inventory.getSizeInventory(); ++i) {
            IEnergyItemInfo energyItemInfo;
            ItemStack item;
            if (player.inventory.getStackInSlot(i) == null || !((item = player.inventory.getStackInSlot(i)).getItem() instanceof IEnergyItemInfo) || (energyItemInfo = (IEnergyItemInfo)item.getItem()).getMaxPower(item) == PoweredItem.getEnergy((ItemStack)item) || !PoweredItem.canUseEnergy((double)energyItemInfo.getMaxPower(item), (ItemStack)itemStack)) continue;
            PoweredItem.useEnergy((double)energyItemInfo.getMaxTransfer(item), (ItemStack)itemStack);
            PoweredItem.setEnergy((double)(PoweredItem.getEnergy((ItemStack)item) + energyItemInfo.getMaxTransfer(item)), (ItemStack)item);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "techreborn:textures/models/lithiumbatpack.png";
    }

    public double getMaxPower(ItemStack stack) {
        return maxCharge;
    }

    public boolean canAcceptEnergy(ItemStack stack) {
        return true;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    public double getMaxTransfer(ItemStack stack) {
        return this.transferLimit;
    }

    public int getStackTier(ItemStack stack) {
        return tier;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        ItemStack uncharged = new ItemStack(ModItems.LITHIUM_BATTERY_PACK);
        ItemStack charged = new ItemStack(ModItems.LITHIUM_BATTERY_PACK);
        PoweredItem.setEnergy((double)this.getMaxPower(charged), (ItemStack)charged);
        itemList.add(uncharged);
        itemList.add(charged);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double charge = PoweredItem.getEnergy((ItemStack)stack) / this.getMaxPower(stack);
        return 1.0 - charge;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }
}

