/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.tools;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.common.powerSystem.PoweredItem;
import techreborn.client.TechRebornCreativeTab;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModItems;
import techreborn.items.ItemTRNoDestroy;

public class ItemCloakingDevice
extends ItemTRNoDestroy
implements IEnergyItemInfo {
    public static int Teir = ConfigTechReborn.CloakingDeviceTier;
    public static int MaxCharge = ConfigTechReborn.CloakingDeviceCharge;
    public static int Limit = 100;
    public static boolean isActive;
    private int armorType = 1;

    public ItemCloakingDevice() {
        this.setUnlocalizedName("techreborn.cloakingdevice");
        this.setMaxStackSize(1);
        this.setCreativeTab(TechRebornCreativeTab.instance);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (PoweredItem.canUseEnergy((double)ConfigTechReborn.CloakingDeviceEUTick, (ItemStack)itemStack)) {
            PoweredItem.useEnergy((double)ConfigTechReborn.CloakingDeviceEUTick, (ItemStack)itemStack);
            player.setInvisible(true);
        } else if (!player.isPotionActive(MobEffects.INVISIBILITY)) {
            player.setInvisible(false);
        }
    }

    public double getMaxPower(ItemStack stack) {
        return MaxCharge;
    }

    public boolean canAcceptEnergy(ItemStack stack) {
        return true;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public double getMaxTransfer(ItemStack stack) {
        return Limit;
    }

    public int getStackTier(ItemStack stack) {
        return Teir;
    }

    public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer player) {
        ItemStack itemstack1 = player.getItemStackFromSlot(EntityEquipmentSlot.CHEST);
        if (itemstack1 == null) {
            player.setItemStackToSlot(EntityEquipmentSlot.CHEST, itemStack.copy());
            itemStack.stackSize = 0;
        }
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        ItemStack uncharged = new ItemStack(ModItems.CLOAKING_DEVICE);
        ItemStack charged = new ItemStack(ModItems.CLOAKING_DEVICE);
        PoweredItem.setEnergy((double)this.getMaxPower(charged), (ItemStack)charged);
        itemList.add(uncharged);
        itemList.add(charged);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double charge = PoweredItem.getEnergy((ItemStack)stack) / this.getMaxPower(stack);
        return 1.0 - charge;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }
}

