/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.tools;

import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.common.powerSystem.PoweredItem;
import techreborn.client.TechRebornCreativeTab;
import techreborn.utils.OreDictUtils;

public class ItemJackhammer
extends ItemPickaxe
implements IEnergyItemInfo {
    public static int tier = 1;
    public int maxCharge = 1;
    public int cost = 250;
    public double transferLimit = 100.0;

    public ItemJackhammer(Item.ToolMaterial material, String unlocalizedName, int energyCapacity, int tier) {
        super(material);
        this.efficiencyOnProperMaterial = 20.0f;
        this.setCreativeTab(TechRebornCreativeTab.instance);
        this.setMaxStackSize(1);
        this.setMaxDamage(240);
        this.setUnlocalizedName(unlocalizedName);
        this.maxCharge = energyCapacity;
        ItemJackhammer.tier = tier;
    }

    public boolean onBlockDestroyed(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entityLiving) {
        Random rand = new Random();
        if (rand.nextInt(EnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantments.UNBREAKING, (ItemStack)stack) + 1) == 0) {
            PoweredItem.useEnergy((double)this.cost, (ItemStack)stack);
        }
        return true;
    }

    public boolean canHarvestBlock(IBlockState state) {
        return OreDictUtils.isOre(state, "stone") || state.getBlock().getMaterial(state) == Material.ROCK && PoweredItem.canUseEnergy((double)this.cost, null);
    }

    public float getStrVsBlock(ItemStack stack, IBlockState state) {
        if ((OreDictUtils.isOre(state, "stone") || state.getBlock() == Blocks.STONE) && PoweredItem.canUseEnergy((double)this.cost, (ItemStack)stack)) {
            return this.efficiencyOnProperMaterial;
        }
        return 0.5f;
    }

    public boolean hitEntity(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase entityliving1) {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public double getMaxPower(ItemStack stack) {
        return this.maxCharge;
    }

    public boolean canAcceptEnergy(ItemStack stack) {
        return true;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    public double getMaxTransfer(ItemStack stack) {
        return this.transferLimit;
    }

    public int getStackTier(ItemStack stack) {
        return tier;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        ItemStack itemStack = new ItemStack((Item)this, 1);
        itemList.add(itemStack);
        ItemStack charged = new ItemStack((Item)this, 1);
        PoweredItem.setEnergy((double)this.getMaxPower(charged), (ItemStack)charged);
        itemList.add(charged);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (PoweredItem.getEnergy((ItemStack)stack) > this.getMaxPower(stack)) {
            return 0.0;
        }
        double charge = PoweredItem.getEnergy((ItemStack)stack) / this.getMaxPower(stack);
        return 1.0 - charge;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }
}

