/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.tools;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.common.powerSystem.PoweredItem;
import reborncore.common.util.ChatUtils;
import techreborn.client.TechRebornCreativeTab;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModItems;
import techreborn.lib.MessageIDs;

public class ItemNanosaber
extends ItemSword
implements IEnergyItemInfo {
    public int cost = 250;

    public ItemNanosaber() {
        super(Item.ToolMaterial.DIAMOND);
        this.setNoRepair();
        this.setCreativeTab(TechRebornCreativeTab.instance);
        this.setMaxStackSize(1);
        this.setUnlocalizedName("techreborn.nanosaber");
        this.addPropertyOverride(new ResourceLocation("techreborn:active"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float apply(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (stack != null && stack.hasTagCompound() && stack.getTagCompound().hasKey("isActive") && stack.getTagCompound().getBoolean("isActive")) {
                    if (PoweredItem.getMaxPower((ItemStack)stack) - PoweredItem.getEnergy((ItemStack)stack) >= 0.9 * PoweredItem.getMaxPower((ItemStack)stack)) {
                        return 0.5f;
                    }
                    return 1.0f;
                }
                return 0.0f;
            }
        });
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        int modifier = 0;
        if (stack != null && stack.getTagCompound().getBoolean("isActive")) {
            modifier = 9;
        }
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.ATTACK_DAMAGE.getName(), (Object)new AttributeModifier(ATTACK_DAMAGE_MODIFIER, "Weapon modifier", (double)modifier, 0));
            multimap.put((Object)SharedMonsterAttributes.ATTACK_SPEED.getName(), (Object)new AttributeModifier(ATTACK_SPEED_MODIFIER, "Weapon modifier", (double)-2.4f, 0));
        }
        return multimap;
    }

    public boolean hitEntity(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase entityliving1) {
        if (PoweredItem.canUseEnergy((double)this.cost, (ItemStack)itemstack)) {
            PoweredItem.useEnergy((double)this.cost, (ItemStack)itemstack);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        ItemStack inactiveUncharged = new ItemStack(ModItems.NANOSABER);
        inactiveUncharged.setTagCompound(new NBTTagCompound());
        inactiveUncharged.getTagCompound().setBoolean("isActive", false);
        ItemStack inactiveCharged = new ItemStack(ModItems.NANOSABER);
        inactiveCharged.setTagCompound(new NBTTagCompound());
        inactiveCharged.getTagCompound().setBoolean("isActive", false);
        PoweredItem.setEnergy((double)this.getMaxPower(inactiveCharged), (ItemStack)inactiveCharged);
        ItemStack activeCharged = new ItemStack(ModItems.NANOSABER);
        activeCharged.setTagCompound(new NBTTagCompound());
        activeCharged.getTagCompound().setBoolean("isActive", true);
        PoweredItem.setEnergy((double)this.getMaxPower(activeCharged), (ItemStack)activeCharged);
        itemList.add(inactiveUncharged);
        itemList.add(inactiveCharged);
        itemList.add(activeCharged);
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (stack.getTagCompound() == null || !stack.getTagCompound().getBoolean("isActive")) {
            list.add(TextFormatting.GRAY + I18n.translateToLocal((String)"techreborn.message.nanosaberInactive"));
        } else {
            list.add(TextFormatting.GRAY + I18n.translateToLocal((String)"techreborn.message.nanosaberActive"));
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public ActionResult<ItemStack> onItemRightClick(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (player.isSneaking()) {
            if (!PoweredItem.canUseEnergy((double)this.cost, (ItemStack)stack)) {
                ChatUtils.sendNoSpamMessages((int)MessageIDs.nanosaberID, (ITextComponent)new TextComponentString(TextFormatting.GRAY + I18n.translateToLocal((String)"techreborn.message.nanosaberEnergyErrorTo") + " " + TextFormatting.GOLD + I18n.translateToLocal((String)"techreborn.message.nanosaberActivate")));
            } else if (stack.getTagCompound() == null || !stack.getTagCompound().getBoolean("isActive")) {
                if (stack.getTagCompound() == null) {
                    stack.setTagCompound(new NBTTagCompound());
                }
                stack.getTagCompound().setBoolean("isActive", true);
                if (!world.isRemote && ConfigTechReborn.NanosaberChat) {
                    ChatUtils.sendNoSpamMessages((int)MessageIDs.nanosaberID, (ITextComponent)new TextComponentString(TextFormatting.GRAY + I18n.translateToLocal((String)"techreborn.message.setTo") + " " + TextFormatting.GOLD + I18n.translateToLocal((String)"techreborn.message.nanosaberActive")));
                }
            } else {
                stack.getTagCompound().setBoolean("isActive", false);
                if (!world.isRemote && ConfigTechReborn.NanosaberChat) {
                    ChatUtils.sendNoSpamMessages((int)MessageIDs.nanosaberID, (ITextComponent)new TextComponentString(TextFormatting.GRAY + I18n.translateToLocal((String)"techreborn.message.setTo") + " " + TextFormatting.GOLD + I18n.translateToLocal((String)"techreborn.message.nanosaberInactive")));
                }
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public void onUpdate(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.getTagCompound() != null && stack.getTagCompound().getBoolean("isActive") && !PoweredItem.canUseEnergy((double)this.cost, (ItemStack)stack)) {
            ChatUtils.sendNoSpamMessages((int)MessageIDs.nanosaberID, (ITextComponent)new TextComponentString(TextFormatting.GRAY + I18n.translateToLocal((String)"techreborn.message.nanosaberEnergyError") + " " + TextFormatting.GOLD + I18n.translateToLocal((String)"techreborn.message.nanosaberDeactivating")));
            stack.getTagCompound().setBoolean("isActive", false);
        }
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (PoweredItem.getEnergy((ItemStack)stack) > this.getMaxPower(stack)) {
            return 0.0;
        }
        double charge = PoweredItem.getEnergy((ItemStack)stack) / this.getMaxPower(stack);
        return 1.0 - charge;
    }

    public boolean isRepairable() {
        return false;
    }

    public double getMaxPower(ItemStack stack) {
        return 100000.0;
    }

    public boolean canAcceptEnergy(ItemStack stack) {
        return true;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    public double getMaxTransfer(ItemStack stack) {
        return 512.0;
    }

    public int getStackTier(ItemStack stack) {
        return 2;
    }
}

