/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.tools;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.common.powerSystem.PoweredItem;
import techreborn.client.TechRebornCreativeTab;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModItems;

public class ItemRockCutter
extends ItemPickaxe
implements IEnergyItemInfo {
    public static final int maxCharge = ConfigTechReborn.RockCutterCharge;
    public static final int tier = ConfigTechReborn.RockCutterTier;
    public int cost = 500;

    public ItemRockCutter() {
        super(Item.ToolMaterial.DIAMOND);
        this.setUnlocalizedName("techreborn.rockcutter");
        this.setCreativeTab(TechRebornCreativeTab.instance);
        this.setMaxStackSize(1);
        this.efficiencyOnProperMaterial = 16.0f;
    }

    public boolean onBlockDestroyed(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entityLiving) {
        Random rand = new Random();
        if (rand.nextInt(EnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantments.UNBREAKING, (ItemStack)stack) + 1) == 0) {
            PoweredItem.useEnergy((double)this.cost, (ItemStack)stack);
        }
        return true;
    }

    public boolean canHarvestBlock(IBlockState state) {
        return Items.DIAMOND_PICKAXE.canHarvestBlock(state);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        if (!stack.isItemEnchanted()) {
            stack.addEnchantment(Enchantment.getEnchantmentByID((int)33), 1);
        }
        return super.getHarvestLevel(stack, toolClass, player, blockState);
    }

    public float getStrVsBlock(ItemStack stack, IBlockState state) {
        if (!PoweredItem.canUseEnergy((double)this.cost, (ItemStack)stack)) {
            return 2.0f;
        }
        return Items.DIAMOND_PICKAXE.getStrVsBlock(stack, state);
    }

    public boolean isRepairable() {
        return false;
    }

    public void onCreated(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        stack.addEnchantment(Enchantments.SILK_TOUCH, 1);
    }

    public double getMaxPower(ItemStack stack) {
        return maxCharge;
    }

    public boolean canAcceptEnergy(ItemStack stack) {
        return true;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    public double getMaxTransfer(ItemStack stack) {
        return 200.0;
    }

    public int getStackTier(ItemStack stack) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        ItemStack uncharged = new ItemStack(ModItems.ROCK_CUTTER);
        ItemStack charged = new ItemStack(ModItems.ROCK_CUTTER);
        PoweredItem.setEnergy((double)this.getMaxPower(charged), (ItemStack)charged);
        itemList.add(uncharged);
        itemList.add(charged);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double charge = PoweredItem.getEnergy((ItemStack)stack) / this.getMaxPower(stack);
        return 1.0 - charge;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }
}

