/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.tools;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.BlockPosContext;
import net.minecraftforge.server.permission.context.IContext;
import reborncore.common.IWrenchable;
import reborncore.common.tile.TileMachineBase;
import techreborn.blocks.fluid.BlockFluidBase;
import techreborn.blocks.storage.BlockEnergyStorage;
import techreborn.client.TechRebornCreativeTabMisc;
import techreborn.compat.CompatManager;
import techreborn.init.ModSounds;
import techreborn.items.ItemTRNoDestroy;
import techreborn.utils.IC2WrenchHelper;

public class ItemWrench
extends ItemTRNoDestroy {
    public ItemWrench() {
        this.setCreativeTab(TechRebornCreativeTabMisc.instance);
        this.setUnlocalizedName("techreborn.wrench");
        this.setMaxStackSize(1);
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        EnumActionResult result;
        if (!PermissionAPI.hasPermission((GameProfile)player.getGameProfile(), (String)"block.wrench", (IContext)new BlockPosContext(player, pos, world.getBlockState(pos), side))) {
            return EnumActionResult.FAIL;
        }
        if (CompatManager.isIC2Loaded && (result = IC2WrenchHelper.onItemUseFirst(player.getHeldItem(hand), player, world, pos, side, hitX, hitY, hitZ, hand)) == EnumActionResult.SUCCESS) {
            return result;
        }
        if (world.isAirBlock(pos)) {
            return EnumActionResult.FAIL;
        }
        TileEntity tile = world.getTileEntity(pos);
        if (tile == null) {
            return EnumActionResult.FAIL;
        }
        if (!player.isSneaking()) {
            if (tile instanceof TileMachineBase && side != EnumFacing.DOWN && side != EnumFacing.UP) {
                ((TileMachineBase)tile).setFacing(side);
                return EnumActionResult.SUCCESS;
            }
            IBlockState state = world.getBlockState(pos);
            if (state.getBlock() instanceof BlockEnergyStorage) {
                EnumFacing facing = (EnumFacing)state.getValue((IProperty)BlockEnergyStorage.FACING);
                facing = facing.getOpposite() == side ? side : side.getOpposite();
                world.setBlockState(pos, state.withProperty((IProperty)BlockEnergyStorage.FACING, (Comparable)facing));
                return EnumActionResult.SUCCESS;
            }
        }
        return super.onItemUseFirst(stack, player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    public EnumActionResult onItemUse(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumActionResult result;
        if (!PermissionAPI.hasPermission((GameProfile)player.getGameProfile(), (String)"block.wrench", (IContext)new BlockPosContext(player, pos, world.getBlockState(pos), facing))) {
            return EnumActionResult.FAIL;
        }
        if (CompatManager.isIC2Loaded && (result = IC2WrenchHelper.onItemUse(player.getHeldItem(hand), player, world, pos, hand, facing, hitX, hitY, hitZ)) == EnumActionResult.SUCCESS) {
            return result;
        }
        if (world.isAirBlock(pos)) {
            return EnumActionResult.FAIL;
        }
        TileEntity tile = world.getTileEntity(pos);
        if (tile == null) {
            return EnumActionResult.FAIL;
        }
        if (!world.isRemote) {
            if (player.isSneaking()) {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                if (tile instanceof IInventory) {
                    IInventory inventory = (IInventory)tile;
                    for (int i = 0; i < inventory.getSizeInventory(); ++i) {
                        ItemStack itemStack = inventory.getStackInSlot(i);
                        if (itemStack == null || itemStack.stackSize <= 0 || !(itemStack.getItem() instanceof ItemBlock) || ((ItemBlock)itemStack.getItem()).block instanceof BlockFluidBase && ((ItemBlock)itemStack.getItem()).block instanceof BlockStaticLiquid && ((ItemBlock)itemStack.getItem()).block instanceof BlockDynamicLiquid) continue;
                        items.add(itemStack.copy());
                    }
                    if (tile instanceof IWrenchable) {
                        if (((IWrenchable)tile).wrenchCanRemove(player)) {
                            ItemStack itemStack = ((IWrenchable)tile).getWrenchDrop(player);
                            if (itemStack == null) {
                                return EnumActionResult.FAIL;
                            }
                            items.add(itemStack);
                        }
                        if (!items.isEmpty()) {
                            for (ItemStack itemStack : items) {
                                Random rand = new Random();
                                float dX = rand.nextFloat() * 0.8f + 0.1f;
                                float dY = rand.nextFloat() * 0.8f + 0.1f;
                                float dZ = rand.nextFloat() * 0.8f + 0.1f;
                                EntityItem entityItem = new EntityItem(world, (double)((float)pos.getX() + dX), (double)((float)pos.getY() + dY), (double)((float)pos.getZ() + dZ), itemStack.copy());
                                if (itemStack.hasTagCompound()) {
                                    entityItem.getEntityItem().setTagCompound(itemStack.getTagCompound().copy());
                                }
                                float factor = 0.05f;
                                entityItem.motionX = rand.nextGaussian() * (double)factor;
                                entityItem.motionY = rand.nextGaussian() * (double)factor + (double)0.2f;
                                entityItem.motionZ = rand.nextGaussian() * (double)factor;
                                if (world.isRemote) continue;
                                world.spawnEntity((Entity)entityItem);
                            }
                        }
                        world.playSound(null, player.posX, player.posY, player.posZ, ModSounds.BLOCK_DISMANTLE, SoundCategory.BLOCKS, 0.6f, 1.0f);
                        if (!world.isRemote) {
                            world.setBlockState(pos, Blocks.AIR.getDefaultState(), 2);
                        }
                        return EnumActionResult.SUCCESS;
                    }
                }
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.FAIL;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isFull3D() {
        return true;
    }
}

