/*
 * Decompiled with CFR 0.152.
 */
package techreborn.manual;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import techreborn.init.ModBlocks;
import techreborn.init.ModItems;
import techreborn.items.ItemParts;
import techreborn.items.ItemPlates;
import techreborn.manual.PageCollection;
import techreborn.manual.pages.AdvancedMachines;
import techreborn.manual.pages.BasicMachinesPage;
import techreborn.manual.pages.ContentsPage;
import techreborn.manual.pages.CraftingInfoPage;
import techreborn.manual.pages.DescriptionPage;
import techreborn.manual.pages.GeneratingPowerPage;
import techreborn.manual.pages.GettingStartedPage;
import techreborn.manual.pages.ToolsPage;

@SideOnly(value=Side.CLIENT)
public class GuiManual
extends GuiScreen {
    protected final PageCollection root = this.createRoot();
    public Container inventorySlots;
    protected int pageIndex = 0;
    protected int xSize = 200;
    protected int ySize = 180;
    protected int guiLeft;
    protected int guiTop;

    protected PageCollection createRoot() {
        this.pageIndex = 0;
        PageCollection pageCollection = new PageCollection();
        pageCollection.addPage(new ContentsPage("contents", pageCollection));
        pageCollection.addPage(new GettingStartedPage("gettingstarted", pageCollection));
        pageCollection.addPage(new DescriptionPage("gettingrubber", pageCollection, true, "gettingrubber2"));
        pageCollection.addPage(new CraftingInfoPage("gettingrubber2", pageCollection, ItemParts.getPartByName("rubber"), "", "gettingrubber"));
        pageCollection.addPage(new CraftingInfoPage("gettingplates", pageCollection, ItemPlates.getPlateByName("iron"), "", "gettingstarted"));
        pageCollection.addPage(new GeneratingPowerPage("generatingpower", pageCollection));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.SOLID_FUEL_GENEREATOR.getLocalizedName(), pageCollection, new ItemStack(ModBlocks.SOLID_FUEL_GENEREATOR), "", "generatingpower"));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.THERMAL_GENERATOR.getLocalizedName(), pageCollection, new ItemStack(ModBlocks.THERMAL_GENERATOR), "", "generatingpower"));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.SOLAR_PANEL.getLocalizedName(), pageCollection, new ItemStack(ModBlocks.SOLAR_PANEL), "", "generatingpower"));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.HEAT_GENERATOR.getLocalizedName(), pageCollection, new ItemStack(ModBlocks.HEAT_GENERATOR), "", "generatingpower"));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.LIGHTNING_ROD.getLocalizedName(), pageCollection, new ItemStack(ModBlocks.LIGHTNING_ROD), "", "generatingpower"));
        pageCollection.addPage(new BasicMachinesPage("basicmachines", pageCollection));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.GRINDER.getLocalizedName(), pageCollection, new ItemStack(ModBlocks.GRINDER), "", "basicmachines"));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.ELECTRIC_FURNACE.getLocalizedName(), pageCollection, new ItemStack(ModBlocks.ELECTRIC_FURNACE), "", "basicmachines"));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.ALLOY_SMELTER.getLocalizedName(), pageCollection, new ItemStack(ModBlocks.ALLOY_SMELTER), "", "basicmachines"));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.EXTRACTOR.getLocalizedName(), pageCollection, new ItemStack(ModBlocks.EXTRACTOR), "", "basicmachines"));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.COMPRESSOR.getLocalizedName(), pageCollection, new ItemStack(ModBlocks.COMPRESSOR), "", "basicmachines"));
        pageCollection.addPage(new AdvancedMachines("advancedmachines", pageCollection));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.INDUSTRIAL_BLAST_FURNACE.getLocalizedName(), pageCollection, new ItemStack(ModBlocks.INDUSTRIAL_BLAST_FURNACE), "", "advancedmachines"));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.INDUSTRIAL_SAWMILL.getLocalizedName(), pageCollection, new ItemStack(ModBlocks.INDUSTRIAL_SAWMILL), "", "advancedmachines"));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.INDUSTRIAL_ELECTROLYZER.getLocalizedName(), pageCollection, new ItemStack(ModBlocks.INDUSTRIAL_ELECTROLYZER), "", "advancedmachines"));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.INDUSTRIAL_GRINDER.getLocalizedName(), pageCollection, new ItemStack(ModBlocks.INDUSTRIAL_GRINDER), "", "advancedmachines"));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.IMPLOSION_COMPRESSOR.getLocalizedName(), pageCollection, new ItemStack(ModBlocks.IMPLOSION_COMPRESSOR), "", "advancedmachines"));
        pageCollection.addPage(new CraftingInfoPage(ModBlocks.INDUSTRIAL_CENTRIFUGE.getLocalizedName(), pageCollection, new ItemStack(ModBlocks.INDUSTRIAL_CENTRIFUGE), "", "advancedmachines"));
        pageCollection.addPage(new ToolsPage("tools", pageCollection));
        pageCollection.addPage(new CraftingInfoPage(ModItems.STEEL_DRILL.getUnlocalizedName() + ".name", pageCollection, new ItemStack(ModItems.STEEL_DRILL), "", "tools"));
        pageCollection.addPage(new CraftingInfoPage(ModItems.DIAMOND_DRILL.getUnlocalizedName() + ".name", pageCollection, new ItemStack(ModItems.DIAMOND_DRILL), "", "tools"));
        pageCollection.addPage(new CraftingInfoPage(ModItems.ADVANCED_DRILL.getUnlocalizedName() + ".name", pageCollection, new ItemStack(ModItems.ADVANCED_DRILL), "", "tools"));
        pageCollection.addPage(new CraftingInfoPage(ModItems.STEEL_CHAINSAW.getUnlocalizedName() + ".name", pageCollection, new ItemStack(ModItems.STEEL_CHAINSAW), "", "tools"));
        pageCollection.addPage(new CraftingInfoPage(ModItems.DIAMOND_CHAINSAW.getUnlocalizedName() + ".name", pageCollection, new ItemStack(ModItems.DIAMOND_CHAINSAW), "", "tools"));
        pageCollection.addPage(new CraftingInfoPage(ModItems.ADVANCED_CHAINSAW.getUnlocalizedName() + ".name", pageCollection, new ItemStack(ModItems.ADVANCED_CHAINSAW), "", "tools"));
        pageCollection.addPage(new CraftingInfoPage(ModItems.OMNI_TOOL.getUnlocalizedName() + ".name", pageCollection, new ItemStack(ModItems.OMNI_TOOL), "", "tools"));
        pageCollection.addPage(new CraftingInfoPage(ModItems.TREE_TAP.getUnlocalizedName() + ".name", pageCollection, new ItemStack(ModItems.TREE_TAP), "", "tools"));
        return pageCollection;
    }

    private int getNextPageIndex() {
        int i = this.pageIndex++;
        return i;
    }

    public void drawScreen(int mouseX, int mouseY, float par3) {
        this.drawGuiBackgroundLayer(par3, mouseX, mouseY);
        super.drawScreen(mouseX, mouseY, par3);
        this.prepareRenderState();
        GL11.glPushMatrix();
        this.root.drawScreen(this.mc, this.guiLeft, this.guiTop, mouseX - this.guiLeft, mouseY - this.guiTop);
        GL11.glPopMatrix();
        this.restoreRenderState();
    }

    protected void prepareRenderState() {
        GL11.glDisable((int)32826);
        RenderHelper.disableStandardItemLighting();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
    }

    protected void restoreRenderState() {
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.enableStandardItemLighting();
    }

    protected void drawGuiBackgroundLayer(float p_146976_1_, int mouseX, int mouseY) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)this.guiLeft, (double)this.guiTop, (double)0.0);
        this.root.renderBackgroundLayer(this.mc, 0, 0, mouseX - this.guiLeft, mouseY - this.guiTop);
        GL11.glPopMatrix();
    }

    public void setWorldAndResolution(Minecraft minecraft, int x, int y) {
        super.setWorldAndResolution(minecraft, x, y);
        this.root.setWorldAndResolution(minecraft, x, y);
    }

    public void actionPerformed(GuiButton button) {
        this.root.actionPerformed(button);
    }

    public void mouseClicked(int par1, int par2, int par3) throws IOException {
        this.root.mouseClicked(par1, par2, par3);
    }

    public void handleInput() throws IOException {
        super.handleInput();
    }

    public void initGui() {
        super.initGui();
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
    }

    public boolean doesGuiPauseGame() {
        return false;
    }
}

