/*
 * Decompiled with CFR 0.152.
 */
package techreborn.manual.loader;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import reborncore.common.util.Unzip;
import techreborn.manual.PageCollection;
import techreborn.manual.loader.DownloadablePackageInfo;
import techreborn.manual.loader.VersionsInfo;
import techreborn.manual.loader.pages.CategoriesPage;
import techreborn.manual.saveFormat.ManualFormat;

public class ManualLoader {
    public static final String MANUAL_VERSION = "0";
    File configDir;
    public static ManualFormat format;
    VersionsInfo info = null;

    public ManualLoader(File configDir) {
        this.configDir = configDir;
    }

    public void load() throws IOException {
        File manualdir = new File(this.configDir, "manual");
        if (!manualdir.exists()) {
            manualdir.mkdir();
        }
        URL url = new URL("http://files.modmuss50.me/techreborn/manual/versions.json");
        URLConnection con = url.openConnection();
        InputStream in = con.getInputStream();
        String encoding = con.getContentEncoding();
        encoding = encoding == null ? "UTF-8" : encoding;
        String body = IOUtils.toString((InputStream)in, (String)encoding);
        Gson gson = new Gson();
        this.info = (VersionsInfo)gson.fromJson(body, new TypeToken<VersionsInfo>(){}.getType());
        DownloadablePackageInfo downloadablePackageInfo = null;
        if (this.info != null) {
            for (DownloadablePackageInfo packageInfo : this.info.versions) {
                if (!packageInfo.packageInfo.version.equals(MANUAL_VERSION)) continue;
                downloadablePackageInfo = packageInfo;
                break;
            }
        }
        if (downloadablePackageInfo != null) {
            String md5;
            boolean hasIntactZip = false;
            File zipLocation = new File(manualdir, downloadablePackageInfo.fileName);
            if (zipLocation.exists()) {
                md5 = ManualLoader.getMD5(zipLocation);
                if (md5.equals(downloadablePackageInfo.md5)) {
                    hasIntactZip = true;
                }
            } else {
                FileUtils.copyURLToFile((URL)new URL("http://files.modmuss50.me/techreborn/manual/packages/" + downloadablePackageInfo.fileName), (File)zipLocation);
                md5 = ManualLoader.getMD5(zipLocation);
                if (md5.equals(downloadablePackageInfo.md5)) {
                    hasIntactZip = true;
                }
            }
            if (hasIntactZip) {
                File outputDir = new File(manualdir, zipLocation.getName().replace(".zip", ""));
                Unzip.unzip((File)zipLocation, (File)outputDir);
                File inputData = new File(outputDir, "master.json");
                BufferedReader reader = new BufferedReader(new FileReader(inputData));
                format = (ManualFormat)gson.fromJson((Reader)reader, ManualFormat.class);
            }
        }
    }

    public static PageCollection getPages() {
        PageCollection pageCollection = new PageCollection();
        pageCollection.addPage(new CategoriesPage("contents", pageCollection));
        return pageCollection;
    }

    public static String getMD5(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        String md5 = DigestUtils.md5Hex((InputStream)fis);
        fis.close();
        return md5;
    }
}

