/*
 * Decompiled with CFR 0.152.
 */
package techreborn.manual.pages;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import techreborn.manual.PageCollection;

public class BasePage
extends GuiScreen {
    public static final ResourceLocation PAGE_TEXTURE = new ResourceLocation("techreborn:textures/manual/gui/manual.png");
    private final int xSize = 200;
    private final int ySize = 180;
    public String INDEX_NAME;
    public boolean hasIndexButton = false;
    protected PageCollection collection;
    private String REFERENCE_NAME;

    public BasePage() {
    }

    public BasePage(String referenceName, PageCollection collection) {
        this.REFERENCE_NAME = referenceName;
        this.mc = Minecraft.getMinecraft();
        this.collection = collection;
        this.initGui();
    }

    public BasePage(String referenceName, boolean showInMenue, PageCollection collection) {
        this(referenceName, collection);
        this.hasIndexButton = showInMenue;
    }

    public int getXMin() {
        return (this.width - 200) / 2;
    }

    public void setXMin(int x) {
        this.width = x;
    }

    public int getYMin() {
        return (this.height - 180) / 2;
    }

    public void setYMin(int y) {
        this.height = y;
    }

    public BasePage setIndexName(String unlocalizedName) {
        this.INDEX_NAME = this.ttl(unlocalizedName);
        return this;
    }

    public String getReferenceName() {
        return this.REFERENCE_NAME;
    }

    public void setReferenceName(String name) {
        this.REFERENCE_NAME = name;
    }

    public void renderBackgroundLayer(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        minecraft.renderEngine.bindTexture(PAGE_TEXTURE);
        this.drawTexturedModalRect(offsetX, offsetY, 0, 0, 200, 180);
    }

    public void renderOverlayComponents(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
    }

    public void drawScreen(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.drawScreen(mouseX + offsetX, mouseY + offsetY, 0.0f);
        this.renderOverlayComponents(minecraft, offsetX, offsetY, mouseX, mouseY);
    }

    public void actionPerformed(GuiButton button) {
        if (button.id == 0) {
            this.collection.changeActivePage("contents");
        }
    }

    public void mouseClicked(int par1, int par2, int par3) throws IOException {
        super.mouseClicked(par1, par2, par3);
    }

    public String ttl(String unlocalizedName) {
        return I18n.translateToLocal((String)unlocalizedName);
    }
}

