/*
 * Decompiled with CFR 0.152.
 */
package techreborn.manual.pages;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import techreborn.manual.PageCollection;
import techreborn.manual.pages.TitledPage;
import techreborn.manual.util.ButtonUtil;

public class DescriptionPage
extends TitledPage {
    public boolean hasImage;
    public String secondpage;
    public String imageprefix = "techreborn:textures/manual/screenshots/";
    private String rawDescription;
    private List<String> formattedDescription;
    private float descriptionScale = 0.88f;

    public DescriptionPage(String name, PageCollection collection, boolean hasImage, String secondPage) {
        super(name, false, collection, "techreborn.manual.gettingstarted", Color.white.getRGB());
        this.hasImage = hasImage;
        this.rawDescription = "techreborn.manual." + this.getReferenceName() + ".description";
        this.secondpage = secondPage;
    }

    @Override
    public void renderOverlayComponents(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        if (this.hasImage) {
            this.renderImage(offsetX, offsetY);
            this.addDescription(this.mc, offsetX, offsetY + 60);
        } else {
            this.addDescription(this.mc, offsetX, offsetY);
        }
    }

    public void initGui() {
        this.buttonList.clear();
        ButtonUtil.addBackButton(0, this.width / 2 - 60, this.height / 2 + 64, this.buttonList);
        if (this.secondpage != null) {
            ButtonUtil.addNextButton(1, this.width / 2 + 40, this.height / 2 + 64, this.buttonList);
        }
    }

    public void renderImage(int offsetX, int offsetY) {
        TextureManager render = Minecraft.getMinecraft().renderEngine;
        render.bindTexture(new ResourceLocation(this.imageprefix + this.getReferenceName() + ".png"));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(offsetX, offsetY - 14, 0, 0, 120, this.height);
        GL11.glDisable((int)3042);
    }

    public void addDescription(Minecraft minecraft, int offsetX, int offsetY) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(offsetX + 15), (double)(offsetY + 40), (double)1.0);
        GL11.glScalef((float)this.descriptionScale, (float)this.descriptionScale, (float)this.descriptionScale);
        int offset = 0;
        for (String s : this.getFormattedText(this.fontRendererObj)) {
            if (s == null) break;
            if (s.contains("\\%") && s.substring(0, 2).equals("\\%")) {
                s = s.substring(2);
                offset += this.fontRendererObj.FONT_HEIGHT / 2;
            }
            this.fontRendererObj.drawString(s, 0, offset, Color.black.getRGB());
            offset += this.fontRendererObj.FONT_HEIGHT;
        }
        GL11.glPopMatrix();
    }

    public List<String> getFormattedText(FontRenderer fr) {
        if (this.formattedDescription == null) {
            this.formattedDescription = new ArrayList<String>();
            if (Strings.isNullOrEmpty((String)this.rawDescription)) {
                this.formattedDescription = ImmutableList.of();
                return this.formattedDescription;
            }
            if (!this.rawDescription.contains("\\n")) {
                this.formattedDescription = ImmutableList.copyOf((Collection)fr.listFormattedStringToWidth(this.rawDescription, 130));
                return this.formattedDescription;
            }
            ArrayList segments = new ArrayList();
            String raw = this.rawDescription;
            for (String s : segments) {
                this.formattedDescription.addAll((Collection<String>)ImmutableList.copyOf((Collection)fr.listFormattedStringToWidth(s, 370)));
            }
        }
        return this.formattedDescription;
    }

    @Override
    public void actionPerformed(GuiButton button) {
        if (button.id == 0) {
            this.collection.changeActivePage("gettingstarted");
        }
        if (this.secondpage != null && button.id == 1) {
            this.collection.changeActivePage(this.secondpage);
        }
    }
}

