/*
 * Decompiled with CFR 0.152.
 */
package techreborn.manual.util;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.opengl.GL11;

public class GuiButtonTextOnly
extends GuiButton {
    public String LINKED_PAGE;
    public int textColour;

    public GuiButtonTextOnly(int id, int xPos, int yPos, int width, int hight, String displayString, String linkedPage, int colour) {
        super(id, xPos, yPos, width, hight, displayString);
        this.LINKED_PAGE = linkedPage;
        this.textColour = colour;
    }

    public void drawButton(Minecraft minecraft, int mouseX, int mouseY) {
        if (this.visible) {
            FontRenderer fontrenderer = minecraft.fontRendererObj;
            minecraft.getTextureManager().bindTexture(BUTTON_TEXTURES);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.hovered = mouseX >= this.xPosition && mouseY >= this.yPosition && mouseX < this.xPosition + this.width && mouseY < this.yPosition + this.height;
            GL11.glEnable((int)3042);
            OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
            GL11.glBlendFunc((int)770, (int)771);
            this.mouseDragged(minecraft, mouseX, mouseY);
            String trimmedDisplayString = this.displayString;
            if (fontrenderer.getStringWidth(this.displayString) > this.width + 30 && !this.hovered) {
                int energencyBreak = 0;
                while ((double)fontrenderer.getStringWidth(trimmedDisplayString) * 0.7 > (double)(this.width - 5)) {
                    trimmedDisplayString = trimmedDisplayString.substring(0, trimmedDisplayString.length() - 1);
                    if (++energencyBreak <= 100) continue;
                }
                trimmedDisplayString = trimmedDisplayString + "...";
            }
            if (this.hovered) {
                trimmedDisplayString = TextFormatting.BOLD + "" + TextFormatting.ITALIC + trimmedDisplayString;
                GL11.glPushMatrix();
                GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                this.drawTexturedModalRect(this.xPosition + (int)((double)this.xPosition * 0.01), this.yPosition + (int)((double)this.yPosition * 0.01), 0, 46, (int)((double)fontrenderer.getStringWidth(trimmedDisplayString) * 0.72) + 2, 8);
                GL11.glPopMatrix();
            }
            GL11.glPushMatrix();
            GL11.glScalef((float)0.7f, (float)0.7f, (float)1.0f);
            fontrenderer.drawString(trimmedDisplayString, (int)((double)this.xPosition * 1.45), (int)((double)(this.yPosition + (this.height - 8) / 2) * 1.45), Color.WHITE.getRGB());
            GL11.glPopMatrix();
        }
    }

    public boolean getIsHovering() {
        return this.hovered;
    }
}

