/*
 * Decompiled with CFR 0.152.
 */
package techreborn.parts.powerCables;

import java.util.List;
import me.modmuss50.jsonDestroyer.api.ITexturedItem;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.RebornCore;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.util.StringUtils;
import reborncore.mcmultipart.item.ItemMultiPart;
import reborncore.mcmultipart.multipart.IMultipart;
import techreborn.client.TechRebornCreativeTab;
import techreborn.parts.TechRebornParts;
import techreborn.parts.powerCables.EnumCableType;
import techreborn.parts.powerCables.ItemStandaloneCables;

public class ItemCables
extends ItemMultiPart
implements ITexturedItem {
    public ItemCables() {
        this.setCreativeTab(TechRebornCreativeTab.instance);
        this.setHasSubtypes(true);
        this.setUnlocalizedName("techreborn.cable");
        this.setNoRepair();
        RebornCore.jsonDestroyer.registerObject((Object)this);
        ItemStandaloneCables.mcPartCable = this;
    }

    public IMultipart createPart(World world, BlockPos pos, EnumFacing side, Vec3d hit, ItemStack stack, EntityPlayer player) {
        try {
            return (IMultipart)TechRebornParts.multipartHashMap.get((Object)EnumCableType.values()[stack.getItemDamage()]).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getUnlocalizedName(ItemStack itemStack) {
        int meta = itemStack.getItemDamage();
        if (meta < 0 || meta >= EnumCableType.values().length) {
            meta = 0;
        }
        return super.getUnlocalizedName() + "." + (Object)((Object)EnumCableType.values()[meta]);
    }

    public void getSubItems(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (int meta = 0; meta < EnumCableType.values().length; ++meta) {
            subItems.add(new ItemStack(itemIn, 1, meta));
        }
    }

    public String getTextureName(int damage) {
        return "techreborn:items/cables/" + EnumCableType.values()[damage].getName();
    }

    public int getMaxMeta() {
        return EnumCableType.values().length;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModel(ItemStack stack, EntityPlayer player, int useRemaining) {
        return new ModelResourceLocation("techreborn:" + this.getUnlocalizedName(stack).substring(5), "inventory");
    }

    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        EnumCableType type = EnumCableType.values()[stack.getItemDamage()];
        tooltip.add(TextFormatting.GRAY + I18n.translateToLocal((String)"desc.transfer") + " " + TextFormatting.GOLD + PowerSystem.getLocaliszedPowerFormatted((int)type.transferRate));
        tooltip.add(TextFormatting.GRAY + I18n.translateToLocal((String)"desc.tier") + " " + TextFormatting.GOLD + StringUtils.toFirstCapitalAllLowercase((String)type.tier.toString()));
        if (type.canKill) {
            tooltip.add(TextFormatting.RED + I18n.translateToLocal((String)"desc.uninsulatedCable"));
        }
    }
}

