/*
 * Decompiled with CFR 0.152.
 */
package techreborn.parts.powerCables;

import java.security.InvalidParameterException;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import reborncore.RebornCore;
import techreborn.client.TechRebornCreativeTab;
import techreborn.items.ItemTextureBase;
import techreborn.parts.StandalonePartCompact;
import techreborn.parts.powerCables.EnumStandaloneCableType;

public class ItemStandaloneCables
extends ItemTextureBase {
    public static Item mcPartCable;

    public ItemStandaloneCables() {
        this.setCreativeTab(TechRebornCreativeTab.instance);
        this.setHasSubtypes(true);
        this.setUnlocalizedName("techreborn.cable");
        this.setNoRepair();
        RebornCore.jsonDestroyer.registerObject((Object)this);
    }

    public static ItemStack getCableByName(String name, int count) {
        for (int i = 0; i < EnumStandaloneCableType.values().length; ++i) {
            if (!EnumStandaloneCableType.values()[i].getName().equalsIgnoreCase(name)) continue;
            return new ItemStack((Item)(mcPartCable != null ? mcPartCable : StandalonePartCompact.itemStandaloneCable), count, i);
        }
        throw new InvalidParameterException("The cable " + name + " could not be found.");
    }

    public static ItemStack getCableByName(String name) {
        return ItemStandaloneCables.getCableByName(name, 1);
    }

    public String getUnlocalizedName(ItemStack itemStack) {
        int meta = itemStack.getItemDamage();
        if (meta < 0 || meta >= EnumStandaloneCableType.values().length) {
            meta = 0;
        }
        return super.getUnlocalizedName() + "." + (Object)((Object)EnumStandaloneCableType.values()[meta]);
    }

    public void getSubItems(Item item, CreativeTabs creativeTabs, List list) {
        for (int meta = 0; meta < EnumStandaloneCableType.values().length; ++meta) {
            list.add(new ItemStack(item, 1, meta));
        }
    }

    public String getTextureName(int damage) {
        return "techreborn:items/cables/" + EnumStandaloneCableType.values()[damage].getName();
    }

    public int getMaxMeta() {
        return EnumStandaloneCableType.values().length;
    }

    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        EnumStandaloneCableType type = EnumStandaloneCableType.values()[stack.getItemDamage()];
        tooltip.add(TextFormatting.GREEN + "EU Transfer: " + TextFormatting.LIGHT_PURPLE + type.transferRate);
        if (type.canKill) {
            tooltip.add(TextFormatting.RED + "Damages entity's!");
        }
        tooltip.add(TextFormatting.RED + "!!INSTALL MCMP TO PLACE CABLES!!");
    }
}

