/*
 * Decompiled with CFR 0.152.
 */
package techreborn.power;

import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import reborncore.api.power.IEnergyInterfaceTile;
import techreborn.parts.powerCables.CableMultipart;
import techreborn.parts.powerCables.EnumCableType;
import techreborn.power.PowerTickEvent;

public class TRPowerNet {
    public ArrayList<EnergyHandler> endpoints = new ArrayList();
    int tick = 0;
    EnumCableType cableType;
    private ArrayList<CableMultipart> cables = new ArrayList();
    private int energy = 0;

    public TRPowerNet(EnumCableType cableType) {
        this.cableType = cableType;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void buildEndpoint(TRPowerNet net) {
        ArrayList<CableMultipart> parts = new ArrayList<CableMultipart>();
        ArrayList<CableMultipart> partsToMerge = new ArrayList<CableMultipart>();
        parts.addAll(net.cables);
        for (CableMultipart cable : parts) {
            for (EnumFacing facing : EnumFacing.VALUES) {
                CableMultipart cableMultipart;
                BlockPos pos = cable.getPos().offset(facing);
                TileEntity tile = cable.getWorld().getTileEntity(pos);
                if (tile instanceof IEnergyInterfaceTile) {
                    IEnergyInterfaceTile eit = (IEnergyInterfaceTile)tile;
                    net.addConnection(eit, facing);
                }
                if ((cableMultipart = CableMultipart.getPartFromWorld(cable.getWorld(), pos, null)) == null || cableMultipart.getNetwork() == net) continue;
                partsToMerge.add(cableMultipart);
            }
        }
        for (CableMultipart cableMultipart : partsToMerge) {
            cableMultipart.mergeWith = net;
        }
        net.checkAndRemoveOldEndpoints();
    }

    public int getIOLimit() {
        return this.cableType.transferRate;
    }

    @SubscribeEvent
    public void tick(PowerTickEvent evt) {
        evt.getWorld().theProfiler.startSection("TechRebornPowerNet");
        if (this.tick < 20) {
            ++this.tick;
            return;
        }
        if (this.tick % 80 == 0) {
            ArrayList<CableMultipart> oldCables = new ArrayList<CableMultipart>();
            for (CableMultipart cableMultipart : this.cables) {
                CableMultipart mp;
                if (cableMultipart.getWorld() == null || cableMultipart.getPos() == null) {
                    oldCables.add(cableMultipart);
                }
                if ((mp = CableMultipart.getPartFromWorld(cableMultipart.getWorld(), cableMultipart.getPos(), null)) != null) continue;
                oldCables.add(cableMultipart);
            }
            this.cables.removeAll(oldCables);
        }
        if (!this.cables.isEmpty()) {
            ArrayList<EnergyHandler> collectibles = new ArrayList<EnergyHandler>();
            ArrayList<EnergyHandler> insertibles = new ArrayList<EnergyHandler>();
            for (EnergyHandler ei : this.endpoints) {
                if (ei.isCollectible()) {
                    collectibles.add(ei);
                }
                if (!ei.isInsertible()) continue;
                insertibles.add(ei);
            }
            if (this.energy < this.cableType.transferRate * this.cables.size()) {
                for (EnergyHandler handler : collectibles) {
                    this.energy += handler.collectEnergy(this.cableType.transferRate);
                }
            }
            for (EnergyHandler handler : insertibles) {
                this.energy -= handler.addEnergy(Math.min(this.energy, this.cableType.transferRate));
            }
        } else {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
        ++this.tick;
        evt.getWorld().theProfiler.endSection();
    }

    public void addElement(CableMultipart te) {
        if (!this.cables.contains(te)) {
            this.cables.add(te);
        }
    }

    public void removeElement(CableMultipart te) {
        this.cables.remove(te);
        this.rebuild();
        this.checkAndRemoveOldEndpoints();
    }

    public void checkAndRemoveOldEndpoints() {
        ArrayList<EnergyHandler> deadHandlers = new ArrayList<EnergyHandler>();
        for (EnergyHandler energyHandler : this.endpoints) {
            TileEntity tile = (TileEntity)energyHandler.tile;
            if (tile.getWorld().getTileEntity(tile.getPos()) == null) {
                deadHandlers.add(energyHandler);
                continue;
            }
            boolean hasNet = false;
            for (EnumFacing facing : EnumFacing.VALUES) {
                BlockPos pos = tile.getPos().offset(facing);
                CableMultipart multipart = CableMultipart.getPartFromWorld(tile.getWorld(), pos, facing);
                if (multipart == null || multipart.getNetwork() != this) continue;
                hasNet = true;
            }
            if (hasNet) continue;
            deadHandlers.add(energyHandler);
        }
        Iterator<EnergyHandler> it = this.endpoints.iterator();
        while (it.hasNext()) {
            EnergyHandler energyHandler;
            energyHandler = it.next();
            if (!deadHandlers.contains(energyHandler)) continue;
            it.remove();
        }
    }

    public void rebuild() {
        for (int i = 0; i < this.cables.size(); ++i) {
            CableMultipart te = this.cables.get(i);
            te.setNetwork(null);
            te.findAndJoinNetwork(te.getWorld(), te.getPos());
        }
        this.clear(true);
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    public int getEnergy() {
        return this.energy;
    }

    public void setEnergy(int energy) {
        if ((energy += energy) < 0) {
            energy = 0;
        }
    }

    public void addConnection(IEnergyInterfaceTile ih, EnumFacing dir) {
        if (ih instanceof CableMultipart) {
            return;
        }
        EnergyHandler has = this.getHandleFrom(ih);
        if (has == null) {
            this.endpoints.add(new EnergyHandler(ih, this.cableType, dir));
        } else {
            has.side = dir;
        }
    }

    public void merge(TRPowerNet n) {
        if (n != this) {
            CableMultipart wire;
            ArrayList<CableMultipart> li = new ArrayList<CableMultipart>();
            for (int i = 0; i < n.cables.size(); ++i) {
                wire = n.cables.get(i);
                li.add(wire);
            }
            for (EnergyHandler ei : n.endpoints) {
                this.endpoints.add(ei);
            }
            n.clear(false);
            for (int i = 0; i < li.size(); ++i) {
                wire = (CableMultipart)li.get(i);
                wire.setNetwork(this);
            }
            this.checkAndRemoveOldEndpoints();
            MinecraftForge.EVENT_BUS.unregister((Object)n);
        }
    }

    private EnergyHandler getHandleFrom(IEnergyInterfaceTile tile) {
        for (EnergyHandler ei : this.endpoints) {
            if (ei.tile != tile) continue;
            return ei;
        }
        return null;
    }

    private void clear(boolean clearTiles) {
        if (clearTiles) {
            for (int i = 0; i < this.cables.size(); ++i) {
                this.cables.get(i).resetNetwork();
            }
        }
        this.cables.clear();
        Iterator<EnergyHandler> it = this.endpoints.iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        this.energy = 0;
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    public int addEnergy(int maxAdd, boolean simulate) {
        if (this.energy >= this.getIOLimit()) {
            return 0;
        }
        maxAdd = Math.min(this.getIOLimit(), maxAdd);
        if (!simulate) {
            this.energy += maxAdd;
        }
        return maxAdd;
    }

    public static class EnergyHandler {
        private final IEnergyInterfaceTile tile;
        private final EnumCableType type;
        private EnumFacing side;

        private EnergyHandler(IEnergyInterfaceTile ih, EnumCableType type, EnumFacing dir) {
            this.tile = ih;
            this.type = type;
            this.side = dir;
        }

        public boolean isInsertible() {
            return this.getTotalInsertible() > 0;
        }

        public boolean isCollectible() {
            return this.getTotalCollectible() > 0;
        }

        public boolean contains(IEnergyInterfaceTile tile) {
            return tile == this.tile;
        }

        public int collectEnergy(int max) {
            int total = 0;
            if (this.tile.canProvideEnergy(this.side.getOpposite())) {
                int collect = (int)Math.min((double)max, Math.min(this.tile.getMaxOutput(), this.tile.getEnergy()));
                total = (int)this.tile.useEnergy((double)collect, false);
            }
            return total;
        }

        public int addEnergy(int max) {
            int total = 0;
            if (this.tile.canAcceptEnergy(this.side.getOpposite()) && max > 0) {
                if (this.type.tier.ordinal() > this.tile.getTier().ordinal() && (double)max > this.tile.getMaxInput()) {
                    if (this.tile instanceof TileEntity) {
                        ((TileEntity)this.tile).getWorld().createExplosion((Entity)new EntityTNTPrimed(((TileEntity)this.tile).getWorld()), (double)((TileEntity)this.tile).getPos().getX(), (double)((TileEntity)this.tile).getPos().getY(), (double)((TileEntity)this.tile).getPos().getZ(), 2.5f, true);
                    }
                    return 0;
                }
                int add = max - total;
                total = (int)((double)total + this.tile.addEnergy((double)add, false));
            }
            return total;
        }

        public int getTotalCollectible() {
            if (this.tile.canProvideEnergy(this.side.getOpposite()) && this.tile.getEnergy() != 0.0) {
                return (int)Math.min(this.tile.getMaxOutput(), this.tile.getEnergy());
            }
            return 0;
        }

        public int getTotalInsertible() {
            int total = 0;
            if (this.tile.canAcceptEnergy(this.side.getOpposite()) && this.tile.getMaxPower() - this.tile.getEnergy() != 0.0) {
                total = (int)((double)total + this.tile.addEnergy((double)this.type.transferRate, true));
            }
            return total;
        }
    }
}

