/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.registry.GameRegistry;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.RecipeHandler;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.recipes.RecipeTranslator;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.api.Reference;
import techreborn.api.recipe.machines.AlloySmelterRecipe;
import techreborn.client.container.IContainerProvider;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.container.builder.ContainerBuilder;
import techreborn.init.ModBlocks;

public class TileAlloyFurnace
extends TileLegacyMachineBase
implements IWrenchable,
IInventoryProvider,
IContainerProvider {
    public int tickTime;
    public Inventory inventory = new Inventory(4, "TileAlloyFurnace", 64, (TileEntity)this);
    public int burnTime;
    public int currentItemBurnTime;
    public int cookTime;
    int input1 = 0;
    int input2 = 1;
    int output = 2;
    int fuel = 3;

    public static int getItemBurnTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        Item item = stack.getItem();
        if (item instanceof ItemBlock && Block.getBlockFromItem((Item)item) != Blocks.AIR) {
            Block block = Block.getBlockFromItem((Item)item);
            if (block == Blocks.WOODEN_SLAB) {
                return 150;
            }
            if (block.getMaterial(block.getDefaultState()) == Material.WOOD) {
                return 300;
            }
            if (block == Blocks.COAL_BLOCK) {
                return 16000;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).getToolMaterialName().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemSword && ((ItemSword)item).getToolMaterialName().equals("WOOD")) {
            return 200;
        }
        if (item == Items.STICK) {
            return 100;
        }
        if (item == Items.COAL) {
            return 1600;
        }
        if (item == Items.LAVA_BUCKET) {
            return 20000;
        }
        if (item == Item.getItemFromBlock((Block)Blocks.SAPLING)) {
            return 100;
        }
        if (item == Items.BLAZE_ROD) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)stack);
    }

    public void updateEntity() {
        super.updateEntity();
        boolean flag = this.burnTime > 0;
        boolean flag1 = false;
        if (this.burnTime > 0) {
            --this.burnTime;
        }
        if (!this.world.isRemote) {
            if (this.burnTime != 0 || this.getStackInSlot(this.input1) != null && this.getStackInSlot(this.fuel) != null) {
                if (this.burnTime == 0 && this.canSmelt()) {
                    this.currentItemBurnTime = this.burnTime = TileAlloyFurnace.getItemBurnTime(this.getStackInSlot(this.fuel));
                    if (this.burnTime > 0) {
                        flag1 = true;
                        if (this.getStackInSlot(this.fuel) != null) {
                            this.decrStackSize(this.fuel, 1);
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == 200) {
                        this.cookTime = 0;
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            }
            if (flag != this.burnTime > 0) {
                flag1 = true;
            }
        }
        if (flag1) {
            this.markDirty();
        }
    }

    public boolean hasAllInputs(IBaseRecipeType recipeType) {
        if (recipeType == null) {
            return false;
        }
        for (Object input : recipeType.getInputs()) {
            boolean hasItem = false;
            boolean useOreDict = input instanceof String || recipeType.useOreDic();
            boolean checkSize = input instanceof ItemStack;
            for (int inputslot = 0; inputslot < 2; ++inputslot) {
                if (!ItemUtils.isInputEqual(input, (ItemStack)this.inventory.getStackInSlot(inputslot), (boolean)true, (boolean)true, (boolean)useOreDict)) continue;
                ItemStack stack = RecipeTranslator.getStackFromObject(input);
                if (checkSize && this.inventory.getStackInSlot((int)inputslot).stackSize < stack.stackSize) continue;
                hasItem = true;
            }
            if (hasItem) continue;
            return false;
        }
        return true;
    }

    private boolean canSmelt() {
        if (this.getStackInSlot(this.input1) == null || this.getStackInSlot(this.input2) == null) {
            return false;
        }
        ItemStack itemstack = null;
        for (IBaseRecipeType recipeType : RecipeHandler.getRecipeClassFromName((String)Reference.alloySmelteRecipe)) {
            if (!this.hasAllInputs(recipeType)) continue;
            itemstack = recipeType.getOutput(0);
            break;
        }
        if (itemstack == null) {
            return false;
        }
        if (this.getStackInSlot(this.output) == null) {
            return true;
        }
        if (!this.getStackInSlot(this.output).isItemEqual(itemstack)) {
            return false;
        }
        int result = this.getStackInSlot((int)this.output).stackSize + itemstack.stackSize;
        return result <= this.getInventoryStackLimit() && result <= this.getStackInSlot(this.output).getMaxStackSize();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = null;
            for (IBaseRecipeType recipeType : RecipeHandler.getRecipeClassFromName((String)Reference.alloySmelteRecipe)) {
                if (this.hasAllInputs(recipeType)) {
                    itemstack = recipeType.getOutput(0);
                    break;
                }
                if (itemstack == null) continue;
                break;
            }
            if (this.getStackInSlot(this.output) == null) {
                this.setInventorySlotContents(this.output, itemstack.copy());
            } else if (this.getStackInSlot(this.output).getItem() == itemstack.getItem()) {
                this.decrStackSize(this.output, -itemstack.stackSize);
            }
            for (IBaseRecipeType recipeType : RecipeHandler.getRecipeClassFromName((String)Reference.alloySmelteRecipe)) {
                boolean hasAllRecipes = true;
                if (!this.hasAllInputs(recipeType)) {
                    hasAllRecipes = false;
                }
                if (!hasAllRecipes) continue;
                block2: for (Object input : recipeType.getInputs()) {
                    boolean useOreDict = input instanceof String || recipeType.useOreDic();
                    for (int inputSlot = 0; inputSlot < 2; ++inputSlot) {
                        if (!ItemUtils.isInputEqual(input, (ItemStack)this.inventory.getStackInSlot(inputSlot), (boolean)true, (boolean)true, (boolean)recipeType.useOreDic())) continue;
                        int count = 1;
                        if (input instanceof ItemStack) {
                            count = RecipeTranslator.getStackFromObject(input).stackSize;
                        }
                        this.inventory.decrStackSize(inputSlot, count);
                        continue block2;
                    }
                }
            }
        }
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    public int getBurnTimeRemainingScaled(int scale) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.burnTime * scale / this.currentItemBurnTime;
    }

    public int getCookProgressScaled(int scale) {
        return this.cookTime * scale / 200;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.isSneaking();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.IRON_ALLOY_FURNACE, 1);
    }

    public boolean isComplete() {
        return false;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public int[] getSlotsForFace(EnumFacing side) {
        return new int[]{0, 1, 2};
    }

    public boolean canInsertItem(int index, ItemStack itemStackIn, EnumFacing direction) {
        return index == 0 || index == 1;
    }

    public boolean canExtractItem(int index, ItemStack stack, EnumFacing direction) {
        return index == 2;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(int burnTime) {
        this.burnTime = burnTime;
    }

    public int getCurrentItemBurnTime() {
        return this.currentItemBurnTime;
    }

    public void setCurrentItemBurnTime(int currentItemBurnTime) {
        this.currentItemBurnTime = currentItemBurnTime;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public void setCookTime(int cookTime) {
        this.cookTime = cookTime;
    }

    @Override
    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("alloyfurnace").player(player.inventory).inventory(8, 84).hotbar(8, 142).addInventory().tile((IInventory)this).filterSlot(0, 47, 17, stack -> RecipeHandler.recipeList.stream().anyMatch(recipe -> recipe instanceof AlloySmelterRecipe && ItemUtils.isInputEqual(recipe.getInputs().get(0), (ItemStack)stack, (boolean)true, (boolean)true, (boolean)true))).filterSlot(1, 65, 17, stack -> RecipeHandler.recipeList.stream().anyMatch(recipe -> recipe instanceof AlloySmelterRecipe && ItemUtils.isInputEqual(recipe.getInputs().get(1), (ItemStack)stack, (boolean)true, (boolean)true, (boolean)true))).outputSlot(2, 116, 35).fuelSlot(3, 56, 53).syncIntegerValue(this::getBurnTime, this::setBurnTime).syncIntegerValue(this::getCookTime, this::setCookTime).syncIntegerValue(this::getCurrentItemBurnTime, this::setCurrentItemBurnTime).addInventory().create();
    }
}

