/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.api.recipe.RecipeHandler;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.api.Reference;
import techreborn.api.recipe.machines.AlloySmelterRecipe;
import techreborn.client.container.IContainerProvider;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.container.builder.ContainerBuilder;
import techreborn.init.ModBlocks;
import techreborn.utils.upgrade.UpgradeHandler;

public class TileAlloySmelter
extends TilePowerAcceptor
implements IWrenchable,
IInventoryProvider,
ISidedInventory,
IRecipeCrafterProvider,
IContainerProvider {
    public int tickTime;
    public Inventory inventory = new Inventory(8, "TileAlloySmelter", 64, (TileEntity)this);
    public RecipeCrafter crafter;
    public int capacity = 1000;
    UpgradeHandler upgrades;

    public TileAlloySmelter() {
        super(1);
        int[] inputs = new int[]{0, 1};
        int[] outputs = new int[]{2};
        this.crafter = new RecipeCrafter(Reference.alloySmelteRecipe, (TileEntity)this, 2, 1, this.inventory, inputs, outputs);
        this.upgrades = new UpgradeHandler(this.crafter, this.inventory, 4, 5, 6, 7);
    }

    public void update() {
        super.update();
        this.crafter.updateEntity();
        this.upgrades.tick();
        this.charge(3);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.isSneaking();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.ALLOY_SMELTER, 1);
    }

    public boolean isComplete() {
        return false;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.inventory.readFromNBT(tagCompound);
        this.crafter.readFromNBT(tagCompound);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        this.crafter.writeToNBT(tagCompound);
        return tagCompound;
    }

    public int[] getSlotsForFace(EnumFacing side) {
        int[] nArray;
        if (side == EnumFacing.DOWN) {
            int[] nArray2 = new int[3];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray = nArray2;
            nArray2[2] = 2;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray = nArray3;
            nArray3[2] = 2;
        }
        return nArray;
    }

    public boolean canInsertItem(int slotIndex, ItemStack itemStack, EnumFacing side) {
        if (slotIndex == 2) {
            return false;
        }
        return this.isItemValidForSlot(slotIndex, itemStack);
    }

    public boolean canExtractItem(int slotIndex, ItemStack itemStack, EnumFacing side) {
        return slotIndex == 2;
    }

    public int getProgressScaled(int scale) {
        if (this.crafter.currentTickTime != 0 && this.crafter.currentNeededTicks != 0) {
            return this.crafter.currentTickTime * scale / this.crafter.currentNeededTicks;
        }
        return 0;
    }

    public double getMaxPower() {
        return this.capacity;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 32.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.LOW;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public RecipeCrafter getRecipeCrafter() {
        return this.crafter;
    }

    @Override
    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("alloysmelter").player(player.inventory).inventory(8, 84).hotbar(8, 142).addInventory().tile((IInventory)this).filterSlot(0, 47, 17, stack -> RecipeHandler.recipeList.stream().anyMatch(recipe -> recipe instanceof AlloySmelterRecipe && ItemUtils.isInputEqual(recipe.getInputs().get(0), (ItemStack)stack, (boolean)true, (boolean)true, (boolean)true))).filterSlot(1, 65, 17, stack -> RecipeHandler.recipeList.stream().anyMatch(recipe -> recipe instanceof AlloySmelterRecipe && ItemUtils.isInputEqual(recipe.getInputs().get(1), (ItemStack)stack, (boolean)true, (boolean)true, (boolean)true))).outputSlot(2, 116, 35).energySlot(3, 56, 53).upgradeSlot(4, 152, 8).upgradeSlot(5, 152, 26).upgradeSlot(6, 152, 44).upgradeSlot(7, 152, 62).syncEnergyValue().syncCrafterValue().addInventory().create();
    }
}

