/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import techreborn.blocks.BlockFlare;
import techreborn.client.particle.ParticleSmoke;

public class TileEntityFlare
extends TileEntity
implements ITickable {
    Random random = new Random();

    public void update() {
        EnumDyeColor color = (EnumDyeColor)this.world.getBlockState(this.pos).getValue(BlockFlare.COLOR);
        if (this.world.isRemote && this.world.isAirBlock(this.getPos().up())) {
            ParticleSmoke particleSmokeLarge = new ParticleSmoke(this.world, (double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5, 0.0, 0.0, 0.0);
            particleSmokeLarge.setMaxAge(250);
            if (color != EnumDyeColor.WHITE) {
                float[] rgb = EntitySheep.getDyeRgb((EnumDyeColor)color);
                particleSmokeLarge.setRBGColorF(rgb[0] + this.random.nextFloat() / 20.0f, rgb[1] + this.random.nextFloat() / 20.0f, rgb[2] + this.random.nextFloat() / 20.0f);
            }
            particleSmokeLarge.multipleParticleScaleBy(0.5f);
            Minecraft.getMinecraft().effectRenderer.addEffect((Particle)particleSmokeLarge);
            this.world.spawnParticle(EnumParticleTypes.FLAME, (double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.3, (double)this.pos.getZ() + 0.5, 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

