/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import techreborn.client.container.IContainerProvider;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.container.builder.ContainerBuilder;

public class TileIronFurnace
extends TileLegacyMachineBase
implements IInventoryProvider,
ISidedInventory,
IContainerProvider {
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_BOTTOM = new int[]{2, 1};
    private static final int[] SLOTS_SIDES = new int[]{1};
    public int tickTime;
    public Inventory inventory = new Inventory(3, "TileIronFurnace", 64, (TileEntity)this);
    public int fuel;
    public int fuelGague;
    public int progress;
    public int fuelScale = 200;
    int input1 = 0;
    int output = 1;
    int fuelslot = 2;
    boolean active = false;

    public int gaugeProgressScaled(int scale) {
        return this.progress * scale / this.fuelScale;
    }

    public int gaugeFuelScaled(int scale) {
        if (this.fuelGague == 0) {
            this.fuelGague = this.fuel;
            if (this.fuelGague == 0) {
                this.fuelGague = this.fuelScale;
            }
        }
        return this.fuel * scale / this.fuelGague;
    }

    public void updateEntity() {
        boolean burning = this.isBurning();
        boolean updateInventory = false;
        if (this.fuel > 0) {
            --this.fuel;
            this.updateState();
        }
        if (this.fuel <= 0 && this.canSmelt()) {
            this.fuel = this.fuelGague = (int)((double)TileEntityFurnace.getItemBurnTime((ItemStack)this.getStackInSlot(this.fuelslot)) * 1.25);
            if (this.fuel > 0) {
                if (this.getStackInSlot(this.fuelslot).getItem().hasContainerItem()) {
                    this.setInventorySlotContents(this.fuelslot, new ItemStack(this.getStackInSlot(this.fuelslot).getItem().getContainerItem()));
                } else if (this.getStackInSlot((int)this.fuelslot).stackSize > 1) {
                    this.decrStackSize(this.fuelslot, 1);
                } else if (this.getStackInSlot((int)this.fuelslot).stackSize == 1) {
                    this.setInventorySlotContents(this.fuelslot, null);
                }
                updateInventory = true;
            }
        }
        if (this.isBurning() && this.canSmelt()) {
            ++this.progress;
            if (this.progress >= this.fuelScale) {
                this.progress = 0;
                this.cookItems();
                updateInventory = true;
            }
        } else {
            this.progress = 0;
        }
        if (burning != this.isBurning()) {
            updateInventory = true;
        }
        if (updateInventory) {
            this.markDirty();
        }
    }

    public void cookItems() {
        if (this.canSmelt()) {
            ItemStack itemstack = FurnaceRecipes.instance().getSmeltingResult(this.getStackInSlot(this.input1));
            if (this.getStackInSlot(this.output) == null) {
                this.setInventorySlotContents(this.output, itemstack.copy());
            } else if (this.getStackInSlot(this.output).isItemEqual(itemstack)) {
                this.getStackInSlot((int)this.output).stackSize += itemstack.stackSize;
            }
            if (this.getStackInSlot((int)this.input1).stackSize > 1) {
                this.decrStackSize(this.input1, 1);
            } else {
                this.setInventorySlotContents(this.input1, null);
            }
        }
    }

    public boolean canSmelt() {
        if (this.getStackInSlot(this.input1) == null) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.instance().getSmeltingResult(this.getStackInSlot(this.input1));
        if (itemstack == null) {
            return false;
        }
        if (this.getStackInSlot(this.output) == null) {
            return true;
        }
        if (!this.getStackInSlot(this.output).isItemEqual(itemstack)) {
            return false;
        }
        int result = this.getStackInSlot((int)this.output).stackSize + itemstack.stackSize;
        return result <= this.getInventoryStackLimit() && result <= itemstack.getMaxStackSize();
    }

    public boolean isBurning() {
        return this.fuel > 0;
    }

    public ItemStack getResultFor(ItemStack stack) {
        ItemStack result = FurnaceRecipes.instance().getSmeltingResult(stack);
        if (result != null) {
            return result.copy();
        }
        return null;
    }

    public void updateState() {
        IBlockState BlockStateContainer2 = this.world.getBlockState(this.pos);
        if (BlockStateContainer2.getBlock() instanceof BlockMachineBase) {
            BlockMachineBase blockMachineBase = (BlockMachineBase)BlockStateContainer2.getBlock();
            if ((Boolean)BlockStateContainer2.getValue((IProperty)BlockMachineBase.ACTIVE) != this.fuel > 0) {
                blockMachineBase.setActive(Boolean.valueOf(this.fuel > 0), this.world, this.pos);
            }
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public int[] getSlotsForFace(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOP : SLOTS_SIDES);
    }

    public boolean canInsertItem(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.isItemValidForSlot(index, itemStackIn);
    }

    public boolean canExtractItem(int index, ItemStack stack, EnumFacing direction) {
        Item item;
        return direction != EnumFacing.DOWN || index != 1 || (item = stack.getItem()) == Items.WATER_BUCKET || item == Items.BUCKET;
    }

    public int getBurnTime() {
        return this.fuel;
    }

    public void setBurnTime(int burnTime) {
        this.fuel = burnTime;
    }

    public int getTotalBurnTime() {
        return this.fuelGague;
    }

    public void setTotalBurnTime(int totalBurnTime) {
        this.fuelGague = totalBurnTime;
    }

    @Override
    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("ironfurnace").player(player.inventory).inventory(8, 84).hotbar(8, 142).addInventory().tile((IInventory)this).slot(0, 56, 17).outputSlot(1, 116, 34).fuelSlot(2, 56, 53).syncIntegerValue(this::getBurnTime, this::setBurnTime).syncIntegerValue(this::getTotalBurnTime, this::setTotalBurnTime).addInventory().create();
    }
}

