/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.client.container.IContainerProvider;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.container.builder.ContainerBuilder;
import techreborn.init.ModBlocks;
import techreborn.init.ModItems;
import techreborn.items.ItemParts;

public class TileMatterFabricator
extends TilePowerAcceptor
implements IWrenchable,
IInventoryProvider,
IContainerProvider {
    public static int fabricationRate = 10000;
    public int tickTime;
    public Inventory inventory = new Inventory(7, "TileMatterFabricator", 64, (TileEntity)this);
    public int progresstime = 0;
    private int amplifier = 0;

    public TileMatterFabricator() {
        super(6);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.isSneaking();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.MATTER_FABRICATOR, 1);
    }

    public boolean isComplete() {
        return false;
    }

    public int maxProgresstime() {
        return fabricationRate;
    }

    public void updateEntity() {
        super.updateEntity();
        if (!this.world.isRemote) {
            for (int i = 0; i < 6; ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (this.amplifier >= 10000 || stack == null) continue;
                int amp = this.getValue(stack) / 32;
                if (!ItemUtils.isItemEqual((ItemStack)stack, (ItemStack)this.inventory.getStackInSlot(i), (boolean)true, (boolean)true) || !this.canUseEnergy(1.0)) continue;
                this.useEnergy(1.0);
                this.amplifier += amp;
                this.inventory.decrStackSize(i, 1);
            }
            if (this.amplifier > 0) {
                if ((double)this.amplifier > this.getEnergy()) {
                    this.progresstime = (int)((double)this.progresstime + this.getEnergy());
                    this.amplifier = (int)((double)this.amplifier - this.getEnergy());
                    this.decreaseStoredEnergy(this.getEnergy(), true);
                } else {
                    this.progresstime += this.amplifier;
                    this.decreaseStoredEnergy(this.amplifier, true);
                    this.amplifier = 0;
                }
            }
            if (this.progresstime > this.maxProgresstime() && this.spaceForOutput()) {
                this.progresstime -= this.maxProgresstime();
                this.addOutputProducts();
            }
        }
    }

    private boolean spaceForOutput() {
        return this.inventory.getStackInSlot(6) == null || ItemUtils.isItemEqual((ItemStack)this.inventory.getStackInSlot(6), (ItemStack)new ItemStack(ModItems.UU_MATTER), (boolean)true, (boolean)true) && this.inventory.getStackInSlot((int)6).stackSize < 64;
    }

    private void addOutputProducts() {
        if (this.inventory.getStackInSlot(6) == null) {
            this.inventory.setInventorySlotContents(6, new ItemStack(ModItems.UU_MATTER));
        } else if (ItemUtils.isItemEqual((ItemStack)this.inventory.getStackInSlot(6), (ItemStack)new ItemStack(ModItems.UU_MATTER), (boolean)true, (boolean)true)) {
            this.inventory.getStackInSlot((int)6).stackSize = Math.min(64, 1 + this.inventory.getStackInSlot((int)6).stackSize);
        }
    }

    public boolean decreaseStoredEnergy(double aEnergy, boolean aIgnoreTooLessEnergy) {
        if (this.getEnergy() - aEnergy < 0.0 && !aIgnoreTooLessEnergy) {
            return false;
        }
        this.setEnergy(this.getEnergy() - aEnergy);
        if (this.getEnergy() < 0.0) {
            this.setEnergy(0.0);
            return false;
        }
        return true;
    }

    public int getValue(ItemStack itemStack) {
        if (itemStack.getItem() == ModItems.PARTS && itemStack.getItemDamage() == ItemParts.getPartByName("scrap").getItemDamage()) {
            return 5000;
        }
        if (itemStack.getItem() == ModItems.SCRAP_BOX) {
            return 45000;
        }
        return 0;
    }

    public double getMaxPower() {
        return 1.0E8;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 4096.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.EXTREME;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public int getProgress() {
        return this.progresstime;
    }

    public void setProgress(int progress) {
        this.progresstime = progress;
    }

    public int getProgressScaled(int scale) {
        if (this.progresstime != 0) {
            return this.progresstime * scale / this.maxProgresstime();
        }
        return 0;
    }

    @Override
    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("matterfabricator").player(player.inventory).inventory(8, 84).hotbar(8, 142).addInventory().tile((IInventory)this).slot(0, 33, 17).slot(1, 33, 35).slot(2, 33, 53).slot(3, 51, 17).slot(4, 51, 35).slot(5, 51, 53).outputSlot(6, 116, 35).syncEnergyValue().syncIntegerValue(this::getProgress, this::setProgress).addInventory().create();
    }
}

