/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import reborncore.api.power.EnumPowerTier;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.WorldUtils;

public class TilePlayerDectector
extends TilePowerAcceptor {
    public String owenerUdid = "";
    boolean redstone = false;

    public TilePlayerDectector() {
        super(1);
    }

    public double getMaxPower() {
        return 10000.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 32.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.LOW;
    }

    public void updateEntity() {
        super.updateEntity();
        if (!this.world.isRemote && this.world.getWorldTime() % 20L == 0L) {
            boolean lastRedstone = this.redstone;
            this.redstone = false;
            if (this.canUseEnergy(10.0)) {
                for (EntityPlayer player : this.world.playerEntities) {
                    if (!(player.getDistanceSq((double)super.getPos().getX() + 0.5, (double)super.getPos().getY() + 0.5, (double)super.getPos().getZ() + 0.5) <= 256.0)) continue;
                    BlockMachineBase blockMachineBase = (BlockMachineBase)this.world.getBlockState(this.pos).getBlock();
                    int meta = blockMachineBase.getMetaFromState(this.world.getBlockState(this.pos));
                    if (meta == 0) {
                        this.redstone = true;
                    } else if (meta == 1) {
                        if (!this.owenerUdid.isEmpty() && !this.owenerUdid.equals(player.getUniqueID().toString())) {
                            this.redstone = true;
                        }
                    } else if (!this.owenerUdid.isEmpty() && this.owenerUdid.equals(player.getUniqueID().toString())) {
                        this.redstone = true;
                    }
                    this.redstone = true;
                }
                this.useEnergy(10.0);
            }
            if (lastRedstone != this.redstone) {
                WorldUtils.updateBlock((World)this.world, (BlockPos)this.getPos());
                this.world.notifyNeighborsOfStateChange(this.getPos(), this.world.getBlockState(this.getPos()).getBlock());
            }
        }
    }

    public boolean isProvidingPower() {
        return this.redstone;
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.owenerUdid = tag.getString("ownerID");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setString("ownerID", this.owenerUdid);
        return tag;
    }
}

