/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.api.RollingMachineRecipe;
import techreborn.client.container.IContainerProvider;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.container.builder.ContainerBuilder;
import techreborn.init.ModBlocks;

public class TileRollingMachine
extends TilePowerAcceptor
implements IWrenchable,
IInventoryProvider,
IContainerProvider {
    public final InventoryCrafting craftMatrix = new InventoryCrafting((Container)new RollingTileContainer(), 3, 3);
    public Inventory inventory = new Inventory(3, "TileRollingMachine", 64, (TileEntity)this);
    public boolean isRunning;
    public int tickTime;
    public int runTime = 250;
    public ItemStack currentRecipe;
    public int euTick = 5;

    public TileRollingMachine() {
        super(1);
    }

    public double getMaxPower() {
        return 100000.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 64.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.LOW;
    }

    public void updateEntity() {
        super.updateEntity();
        this.charge(2);
        if (!this.world.isRemote) {
            this.currentRecipe = RollingMachineRecipe.instance.findMatchingRecipe(this.craftMatrix, this.world);
            if (this.currentRecipe != null && this.canMake() && this.tickTime >= this.runTime) {
                this.currentRecipe = RollingMachineRecipe.instance.findMatchingRecipe(this.craftMatrix, this.world);
                if (this.currentRecipe != null) {
                    boolean hasCrafted = false;
                    if (this.inventory.getStackInSlot(0) == null) {
                        this.inventory.setInventorySlotContents(0, this.currentRecipe);
                        this.tickTime = -1;
                        hasCrafted = true;
                    } else if (this.inventory.getStackInSlot((int)0).stackSize + this.currentRecipe.stackSize <= this.currentRecipe.getMaxStackSize()) {
                        ItemStack stack = this.inventory.getStackInSlot(0);
                        stack.stackSize += this.currentRecipe.stackSize;
                        this.inventory.setInventorySlotContents(0, stack);
                        this.tickTime = -1;
                        hasCrafted = true;
                    }
                    if (hasCrafted) {
                        for (int i = 0; i < this.craftMatrix.getSizeInventory(); ++i) {
                            this.craftMatrix.decrStackSize(i, 1);
                        }
                        this.currentRecipe = null;
                    }
                }
            }
            if (this.currentRecipe != null && this.canUseEnergy(this.euTick) && this.tickTime < this.runTime) {
                this.useEnergy(this.euTick);
                ++this.tickTime;
            }
            if (this.currentRecipe == null) {
                this.tickTime = -1;
            }
        } else {
            this.currentRecipe = RollingMachineRecipe.instance.findMatchingRecipe(this.craftMatrix, this.world);
            if (this.currentRecipe != null) {
                this.inventory.setInventorySlotContents(1, this.currentRecipe);
            } else {
                this.inventory.setInventorySlotContents(1, null);
            }
        }
    }

    public boolean canMake() {
        return RollingMachineRecipe.instance.findMatchingRecipe(this.craftMatrix, this.world) != null;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.isSneaking();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.ROLLING_MACHINE, 1);
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        ItemUtils.readInvFromNBT((IInventory)this.craftMatrix, (String)"Crafting", (NBTTagCompound)tagCompound);
        this.isRunning = tagCompound.getBoolean("isRunning");
        this.tickTime = tagCompound.getInteger("tickTime");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        ItemUtils.writeInvToNBT((IInventory)this.craftMatrix, (String)"Crafting", (NBTTagCompound)tagCompound);
        this.writeUpdateToNBT(tagCompound);
        return tagCompound;
    }

    public void writeUpdateToNBT(NBTTagCompound tagCompound) {
        tagCompound.setBoolean("isRunning", this.isRunning);
        tagCompound.setInteger("tickTime", this.tickTime);
    }

    public void invalidate() {
        super.invalidate();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public int getBurnTime() {
        return this.tickTime;
    }

    public void setBurnTime(int burnTime) {
        this.tickTime = burnTime;
    }

    public int getBurnTimeRemainingScaled(int scale) {
        if (this.tickTime == 0 || this.runTime == 0) {
            return 0;
        }
        return this.tickTime * scale / this.runTime;
    }

    @Override
    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("rollingmachine").player(player.inventory).inventory(8, 84).hotbar(8, 142).addInventory().tile((IInventory)this.craftMatrix).slot(0, 30, 17).slot(1, 48, 17).slot(2, 66, 17).slot(3, 30, 35).slot(4, 48, 35).slot(5, 66, 35).slot(6, 30, 53).slot(7, 48, 53).slot(8, 66, 53).onCraft(inv -> this.inventory.setInventorySlotContents(1, RollingMachineRecipe.instance.findMatchingRecipe((InventoryCrafting)inv, this.world))).addInventory().tile((IInventory)this).outputSlot(0, 124, 35).energySlot(2, 8, 51).syncEnergyValue().syncIntegerValue(this::getBurnTime, this::setBurnTime).addInventory().create();
    }

    private static class RollingTileContainer
    extends Container {
        private RollingTileContainer() {
        }

        public boolean canInteractWith(EntityPlayer entityplayer) {
            return true;
        }
    }
}

