/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import techreborn.api.ScrapboxList;
import techreborn.client.container.IContainerProvider;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.container.builder.ContainerBuilder;
import techreborn.init.ModBlocks;
import techreborn.init.ModItems;

public class TileScrapboxinator
extends TilePowerAcceptor
implements IWrenchable,
IInventoryProvider,
ISidedInventory,
IContainerProvider {
    public Inventory inventory = new Inventory(6, "TileScrapboxinator", 64, (TileEntity)this);
    public int capacity = 1000;
    public int cost = 20;
    public int progress;
    public int time = 200;
    public int chance = 4;
    public int random;
    public int input1 = 0;
    public int output = 1;

    public TileScrapboxinator() {
        super(1);
    }

    public int gaugeProgressScaled(int scale) {
        return this.progress * scale / this.time;
    }

    public void updateEntity() {
        boolean burning = this.isBurning();
        boolean updateInventory = false;
        if (this.getEnergy() <= (double)this.cost && this.canOpen() && this.getEnergy() > (double)this.cost) {
            updateInventory = true;
        }
        if (this.isBurning() && this.canOpen()) {
            this.updateState();
            ++this.progress;
            if (this.progress >= this.time) {
                this.progress = 0;
                this.recycleItems();
                updateInventory = true;
            }
        } else {
            this.progress = 0;
            this.updateState();
        }
        if (burning != this.isBurning()) {
            updateInventory = true;
        }
        if (updateInventory) {
            this.markDirty();
        }
    }

    public void recycleItems() {
        if (this.canOpen() && !this.world.isRemote) {
            int random = new Random().nextInt(ScrapboxList.stacks.size());
            ItemStack out = ScrapboxList.stacks.get(random).copy();
            if (this.getStackInSlot(this.output) == null) {
                this.useEnergy(this.cost);
                this.setInventorySlotContents(this.output, out);
            }
            if (this.getStackInSlot((int)this.input1).stackSize > 1) {
                this.useEnergy(this.cost);
                this.decrStackSize(this.input1, 1);
            } else {
                this.useEnergy(this.cost);
                this.setInventorySlotContents(this.input1, null);
            }
        }
    }

    public boolean canOpen() {
        return this.getStackInSlot(this.input1) != null && this.getStackInSlot(this.output) == null;
    }

    public boolean isBurning() {
        return this.getEnergy() > (double)this.cost;
    }

    public void updateState() {
        IBlockState blockState = this.world.getBlockState(this.pos);
        if (blockState.getBlock() instanceof BlockMachineBase) {
            BlockMachineBase blockMachineBase = (BlockMachineBase)blockState.getBlock();
            if ((Boolean)blockState.getValue((IProperty)BlockMachineBase.ACTIVE) != this.progress > 0) {
                blockMachineBase.setActive(Boolean.valueOf(this.progress > 0), this.world, this.pos);
            }
        }
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.isSneaking();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.SCRAPBOXINATOR, 1);
    }

    public boolean isComplete() {
        return false;
    }

    public int[] getSlotsForFace(EnumFacing side) {
        int[] nArray;
        if (side == EnumFacing.DOWN) {
            int[] nArray2 = new int[3];
            nArray2[0] = 0;
            nArray2[1] = 1;
            nArray = nArray2;
            nArray2[2] = 2;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray = nArray3;
            nArray3[2] = 2;
        }
        return nArray;
    }

    public boolean canInsertItem(int slotIndex, ItemStack itemStack, EnumFacing side) {
        if (slotIndex == 2) {
            return false;
        }
        if (slotIndex == 1 && itemStack.getItem() == ModItems.SCRAP_BOX) {
            return true;
        }
        return this.isItemValidForSlot(slotIndex, itemStack);
    }

    public boolean canExtractItem(int slotIndex, ItemStack itemStack, EnumFacing side) {
        return slotIndex == 2;
    }

    public double getMaxPower() {
        return this.capacity;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 32.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.MEDIUM;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    @Override
    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("scrapboxinator").player(player.inventory).inventory(8, 84).hotbar(8, 142).addInventory().tile((IInventory)this).filterSlot(0, 56, 34, stack -> stack.getItem() == ModItems.SCRAP_BOX).outputSlot(1, 116, 34).upgradeSlot(2, 152, 8).upgradeSlot(3, 152, 26).upgradeSlot(4, 152, 44).upgradeSlot(5, 152, 62).syncEnergyValue().syncIntegerValue(this::getProgress, this::setProgress).addInventory().create();
    }
}

