/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;
import reborncore.api.IListInfoProvider;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;

public class TileTechStorageBase
extends TileLegacyMachineBase
implements IInventoryProvider,
IWrenchable,
IListInfoProvider,
IDeepStorageUnit {
    public final int maxCapacity;
    public final Inventory inventory;
    public InvWrapper invWrapper;
    public ItemStack storedItem;

    public TileTechStorageBase(String name, int maxCapacity) {
        this.maxCapacity = maxCapacity;
        this.storedItem = null;
        this.inventory = new Inventory(3, name, maxCapacity, (TileEntity)this);
    }

    public void updateEntity() {
        if (!this.world.isRemote) {
            if (this.getStackInSlot(0) != null) {
                if (this.getStoredItemType() == null || this.getStoredItemType() == null && ItemUtils.isItemEqual((ItemStack)this.getStackInSlot(0), (ItemStack)this.getStackInSlot(1), (boolean)true, (boolean)true)) {
                    this.storedItem = this.getStackInSlot(0);
                    this.setInventorySlotContents(0, null);
                    this.syncWithAll();
                } else if (ItemUtils.isItemEqual((ItemStack)this.getStoredItemType(), (ItemStack)this.getStackInSlot(0), (boolean)true, (boolean)true)) {
                    this.setStoredItemCount(this.getStackInSlot((int)0).stackSize);
                    this.setInventorySlotContents(0, null);
                    this.syncWithAll();
                }
            }
            if (this.storedItem != null) {
                if (this.getStackInSlot(1) == null) {
                    ItemStack delivered = this.storedItem.copy();
                    delivered.stackSize = Math.min(this.storedItem.stackSize, delivered.getMaxStackSize());
                    this.storedItem.stackSize -= delivered.stackSize;
                    if (this.storedItem.stackSize == 0) {
                        this.storedItem = null;
                    }
                    this.setInventorySlotContents(1, delivered);
                    this.syncWithAll();
                } else if (ItemUtils.isItemEqual((ItemStack)this.storedItem, (ItemStack)this.getStackInSlot(1), (boolean)true, (boolean)true) && this.getStackInSlot((int)1).stackSize < this.getStackInSlot(1).getMaxStackSize()) {
                    int wanted = Math.min(this.storedItem.stackSize, this.getStackInSlot(1).getMaxStackSize() - this.getStackInSlot((int)1).stackSize);
                    this.getStackInSlot((int)1).stackSize += wanted;
                    this.storedItem.stackSize -= wanted;
                    if (this.storedItem.stackSize == 0) {
                        this.storedItem = null;
                    }
                    this.syncWithAll();
                }
            }
        }
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.world.markBlockRangeForRenderUpdate(this.getPos().getX(), this.getPos().getY(), this.getPos().getZ(), this.getPos().getX(), this.getPos().getY(), this.getPos().getZ());
        this.readFromNBT(packet.getNbtCompound());
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.readFromNBTWithoutCoords(tagCompound);
    }

    public void readFromNBTWithoutCoords(NBTTagCompound tagCompound) {
        this.storedItem = null;
        if (tagCompound.hasKey("storedStack")) {
            this.storedItem = ItemStack.loadItemStackFromNBT((NBTTagCompound)((NBTTagCompound)tagCompound.getTag("storedStack")));
        }
        if (this.storedItem != null) {
            this.storedItem.stackSize = tagCompound.getInteger("storedQuantity");
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        this.writeToNBTWithoutCoords(tagCompound);
        return tagCompound;
    }

    public NBTTagCompound writeToNBTWithoutCoords(NBTTagCompound tagCompound) {
        if (this.storedItem != null) {
            tagCompound.setTag("storedStack", (NBTBase)this.storedItem.writeToNBT(new NBTTagCompound()));
            tagCompound.setInteger("storedQuantity", this.storedItem.stackSize);
        } else {
            tagCompound.setInteger("storedQuantity", 0);
        }
        return tagCompound;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.isSneaking();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return this.getDropWithNBT();
    }

    public ItemStack getDropWithNBT() {
        NBTTagCompound tileEntity = new NBTTagCompound();
        ItemStack dropStack = new ItemStack(this.getBlockType(), 1);
        this.writeToNBTWithoutCoords(tileEntity);
        dropStack.setTagCompound(new NBTTagCompound());
        dropStack.getTagCompound().setTag("tileEntity", (NBTBase)tileEntity);
        return dropStack;
    }

    public List<ItemStack> getContentDrops() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (this.getStoredItemType() != null) {
            if (this.getStackInSlot(1) != null) {
                stacks.add(this.getStackInSlot(1));
            }
            for (int i = 0; i < this.getStoredCount() / 64; ++i) {
                ItemStack droped = this.storedItem.copy();
                droped.stackSize = 64;
                stacks.add(droped);
            }
            if (this.getStoredCount() % 64 != 0) {
                ItemStack droped = this.storedItem.copy();
                droped.stackSize = this.getStoredCount() % 64;
                stacks.add(droped);
            }
        }
        return stacks;
    }

    public ItemStack getStoredItemType() {
        return this.storedItem == null ? this.getStackInSlot(1) : this.storedItem;
    }

    public void setStoredItemCount(int amount) {
        this.storedItem.stackSize += amount;
        this.markDirty();
    }

    public void setStoredItemType(ItemStack type, int amount) {
        this.storedItem = type;
        this.storedItem.stackSize = amount;
        this.markDirty();
    }

    public int getMaxStoredCount() {
        return this.maxCapacity;
    }

    public int getStoredCount() {
        return this.storedItem.stackSize;
    }

    public void addInfo(List<String> info, boolean isRealTile) {
        if (isRealTile) {
            int size = 0;
            String name = "of nothing";
            if (this.storedItem != null) {
                name = this.storedItem.getDisplayName();
                size += this.storedItem.stackSize;
            }
            if (this.getStackInSlot(1) != null) {
                name = this.getStackInSlot(1).getDisplayName();
                size += this.getStackInSlot((int)1).stackSize;
            }
            info.add(size + " " + name);
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.getInvWrapper();
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public InvWrapper getInvWrapper() {
        if (this.invWrapper == null) {
            this.invWrapper = new InvWrapper((IInventory)this);
        }
        return this.invWrapper;
    }
}

